/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.autoplot.ApplicationModel;
import org.autoplot.AutoplotUtil;
import org.autoplot.JythonUtil;
import org.autoplot.ScriptContext;
import org.autoplot.ScriptContext2023;
import org.autoplot.bookmarks.Bookmark;
import org.autoplot.datasource.DataSetSelector;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.WindowManager;
import org.autoplot.dom.Application;
import org.autoplot.jythonsupport.JythonRefactory;
import org.autoplot.jythonsupport.Param;
import org.autoplot.jythonsupport.ui.ParametersFormPanel;
import org.autoplot.jythonsupport.ui.Util;
import org.autoplot.pngwalk.PngWalkTool;
import org.das2.components.DasProgressPanel;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.DatumUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.fsm.FileStorageModel;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.FileUtil;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.AlertNullProgressMonitor;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.python.util.InteractiveInterpreter;
import org.python.util.PythonInterpreter;

public class RunBatchTool
extends JPanel {
    private static final Logger logger = LoggerManager.getLogger((String)"jython.batchmaster");
    private Application dom;
    private Object state;
    private static final String STATE_READY = "ready";
    private static final String STATE_LOADING = "loading";
    private JSONObject results = null;
    private JSONObject resultsPending = null;
    private File resultsFile = null;
    private JLabel[] param1JLabels = null;
    private Param[] parameterDescriptions;
    private final Map<JLabel, String> jobs = new HashMap<JLabel, String>();
    public static final int HTML_LINE_LIMIT = 50;
    private ProgressMonitor monitor = null;
    private final Preferences prefs;
    private static final String PREF_THREAD_COUNT = "threadCount";
    private String pwd;
    private static final Icon ICON_QUEUED = new ImageIcon(RunBatchTool.class.getResource("/resources/grey.gif"));
    private static final Icon ICON_WORKING = new ImageIcon(RunBatchTool.class.getResource("/resources/blue_anime.gif"));
    private static final Icon ICON_OKAY = new ImageIcon(RunBatchTool.class.getResource("/resources/blue.gif"));
    private static final Icon ICON_PROB = new ImageIcon(RunBatchTool.class.getResource("/resources/red.gif"));
    private static final String RUNNING_LABEL_MOUSEOVER = "Running jobs, mouse over to view tooltip containing standard output.";
    private JMenuItem OpenMenuItem;
    private JMenuItem SaveAsMenuItem;
    private JCheckBox activeFocusCB;
    private JButton cancelButton;
    private JButton closeButton;
    private JMenuItem copyScriptUri;
    private JMenuItem copyValueMenuItem;
    private DataSetSelector dataSetSelector1;
    private JButton deleteDirectoryButton;
    private JButton editParamsButton;
    private JMenuItem exportResultsMenuItem;
    private JMenu fileMenu;
    private JButton generateButton1;
    private JButton generateButton2;
    private JMenuItem generateMenuItem1;
    private JMenuItem generateMenuItem2;
    private JButton goButton;
    private JMenu helpMenu;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JList<String> jList2;
    private JPanel jPanel1;
    private JPopupMenu jPopupMenu1;
    private JPopupMenu jPopupMenu2;
    private JScrollPane jScrollPane2;
    private JMenuItem loadFromFileMI;
    private JMenuItem loadFromFileMI2;
    private JMenuItem loadUriMenuItem;
    private JMenuItem loadUriMenuItem2;
    private JMenuBar menuBar;
    private JLabel messageLabel;
    private JComboBox<String> param1NameCB;
    private JScrollPane param1ScrollPane;
    private JTextArea param1Values;
    private JComboBox<String> param2NameCB;
    private JScrollPane param2ScrollPane;
    private JTextArea param2Values;
    private JMenuItem pasteMenuItem;
    private JMenuItem pasteMenuItem2;
    private JButton pngWalkToolButton;
    private JPopupMenu postRunPopupMenu;
    private JPanel progressPanel;
    private JMenuItem rerunScriptMenuItem;
    private JMenuItem showHelpMenuItem;
    private JComboBox<String> timeFormatComboBox;
    private JComboBox<String> timeRangeComboBox;
    private JPanel timeRangesPanel;
    private JCheckBox writeCheckBox;
    private JComboBox<String> writeFilenameCB;
    private BindingGroup bindingGroup;
    private JLabel selectedLabel;

    public RunBatchTool(final Application dom) {
        this.initComponents();
        this.messageLabel.setPreferredSize(new Dimension(this.messageLabel.getFont().getSize() * 50, this.messageLabel.getFont().getSize()));
        this.messageLabel.setMaximumSize(this.messageLabel.getPreferredSize());
        this.registerKeyboardAction(e -> {
            LoggerManager.logGuiEvent((ActionEvent)e);
            JDialog dia = (JDialog)SwingUtilities.getWindowAncestor(this.cancelButton);
            if (this.cancelButton.isEnabled()) {
                dia.setVisible(false);
                dia.dispose();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        this.writeFilenameCB.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                RunBatchTool.this.checkNumberOfParams();
            }
        });
        this.prefs = Preferences.userNodeForPackage(RunBatchTool.class);
        String s = this.prefs.get("lastTemplate", null);
        if (s != null) {
            this.writeFilenameCB.setSelectedItem(s);
        }
        this.generateButton1.setEnabled(false);
        this.generateButton2.setEnabled(false);
        this.generateMenuItem1.setEnabled(false);
        this.generateMenuItem2.setEnabled(false);
        this.dom = dom;
        this.state = STATE_READY;
        this.dataSetSelector1.registerBrowseTrigger("(.*)\\.jy(\\?.*)?", (Action)new AbstractAction("Review Script"){

            @Override
            public void actionPerformed(ActionEvent ev) {
                LoggerManager.logGuiEvent((ActionEvent)ev);
                RunBatchTool.this.state = RunBatchTool.STATE_LOADING;
                String s = RunBatchTool.this.dataSetSelector1.getValue();
                try {
                    URISplit split = URISplit.parse((String)s);
                    LinkedHashMap args = URISplit.parseParams((String)split.params);
                    HashMap<String, Object> env = new HashMap<String, Object>();
                    env.put("dom", dom);
                    env.put("PWD", split.path);
                    File scriptFile = DataSetURI.getFile((String)s, (ProgressMonitor)new NullProgressMonitor());
                    if (0 == JythonUtil.showScriptDialog(RunBatchTool.this, env, scriptFile, args, this.enabled, split.resourceUri)) {
                        split.params = URISplit.formatParams((Map)args);
                        RunBatchTool.this.dataSetSelector1.setValue(URISplit.format((URISplit)split));
                    }
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                finally {
                    RunBatchTool.this.state = RunBatchTool.STATE_READY;
                }
            }
        });
        this.dataSetSelector1.registerActionTrigger("(.*)\\.jy(\\?.*)?", (Action)new AbstractAction("Review Script"){

            @Override
            public void actionPerformed(ActionEvent ev) {
                LoggerManager.logGuiEvent((ActionEvent)ev);
                RunBatchTool.this.doPlayButton();
            }
        });
        this.dataSetSelector1.setPromptText("Enter the name of a Jython script");
        ArrayList<String> recentUris = new ArrayList<String>(20);
        recentUris.add("https://github.com/autoplot/dev/blob/master/demos/2019/20190726/demoParams.jy");
        if (dom.getController() != null) {
            Pattern p = Pattern.compile(".*\\.jy(\\?.*)?");
            Map<String, String> recentJy = dom.getController().getApplicationModel().getRecent(p, 20);
            recentJy.entrySet().forEach(recentItem -> recentUris.add((String)recentItem.getKey()));
        }
        this.dataSetSelector1.setRecent(recentUris);
        this.param1ScrollPane.getVerticalScrollBar().setUnitIncrement(this.param1ScrollPane.getFont().getSize());
        this.param2ScrollPane.getVerticalScrollBar().setUnitIncrement(this.param2ScrollPane.getFont().getSize());
        this.timeRangeComboBox.setSelectedItem(this.prefs.get("lastTimeRange", "2000-Jan"));
        this.timeFormatComboBox.setSelectedItem(this.prefs.get("lastTimeFormat", "$Y-$m-$d"));
    }

    private void checkNumberOfParams() {
        if ("T".equals(System.getProperty("autoplot.option.runbatch.validate", "T"))) {
            int npp2;
            String s = this.writeFilenameCB.getEditor().getItem().toString();
            int fields1 = s.split("\\$|\\%", -2).length - 1;
            String pp1 = this.param1NameCB.getSelectedItem() != null ? this.param1NameCB.getSelectedItem().toString().trim() : "";
            int npp1 = pp1.length() == 0 ? 0 : pp1.split("\\;", -2).length;
            String pp2 = this.param2NameCB.getSelectedItem() != null ? this.param2NameCB.getSelectedItem().toString().trim() : "";
            int n = npp2 = pp2.length() == 0 ? 0 : pp2.split("\\;", -2).length;
            if (npp1 + npp2 != fields1 && this.writeCheckBox.isSelected()) {
                this.writeFilenameCB.getEditor().getEditorComponent().setBackground(Color.YELLOW);
            } else if (this.writeFilenameCB.getEditor().getEditorComponent().getForeground() == Color.WHITE) {
                this.writeFilenameCB.getEditor().getEditorComponent().setBackground(Color.BLACK);
            } else {
                this.writeFilenameCB.getEditor().getEditorComponent().setBackground(Color.WHITE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPlayButton() {
        this.state = STATE_LOADING;
        try {
            String scriptName = this.dataSetSelector1.getValue();
            URISplit split = URISplit.parse((String)scriptName);
            if (!split.file.endsWith(".jy")) {
                JOptionPane.showMessageDialog(this, "script must end in .jy: " + scriptName);
                return;
            }
            this.pwd = split.path;
            HashMap<String, Object> env = new HashMap<String, Object>();
            DasProgressPanel monitor = DasProgressPanel.createFramed((Window)SwingUtilities.getWindowAncestor(this), (String)"download script");
            File scriptFile = DataSetURI.getFile((String)split.file, (ProgressMonitor)monitor);
            String script = this.readScript(scriptFile);
            env.put("dom", this.dom);
            env.put("PWD", split.path);
            Map parms = Util.getParams(env, (String)script, (Map)URISplit.parseParams((String)split.params), (ProgressMonitor)new NullProgressMonitor());
            String[] items = new String[parms.size() + 2];
            int i = 0;
            items[0] = "";
            for (Map.Entry p : parms.entrySet()) {
                items[i + 1] = (String)p.getKey();
                ++i;
            }
            items[parms.size() + 1] = "Select Multiple...";
            DefaultComboBoxModel<String> m1 = new DefaultComboBoxModel<String>(Arrays.copyOfRange(items, 1, items.length));
            this.param1NameCB.setModel(m1);
            this.generateButton1.setEnabled(items.length > 1);
            this.generateMenuItem1.setEnabled(items.length > 1);
            DefaultComboBoxModel<String> m2 = new DefaultComboBoxModel<String>(items);
            this.param2NameCB.setModel(m2);
            this.param1Values.setText("");
            this.param2Values.setText("");
            this.switchToEditableList();
            this.messageLabel.setText("Load up those parameters and hit Go!");
            this.param1ScrollPane.getViewport().setView(this.param1Values);
        }
        catch (IOException ex) {
            Logger.getLogger(RunBatchTool.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            this.state = STATE_READY;
        }
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.jScrollPane2 = new JScrollPane();
        this.jList2 = new JList();
        this.jPopupMenu1 = new JPopupMenu();
        this.generateMenuItem1 = new JMenuItem();
        this.loadUriMenuItem = new JMenuItem();
        this.loadFromFileMI = new JMenuItem();
        this.pasteMenuItem = new JMenuItem();
        this.timeRangesPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.timeRangeComboBox = new JComboBox();
        this.timeFormatComboBox = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jPopupMenu2 = new JPopupMenu();
        this.generateMenuItem2 = new JMenuItem();
        this.loadUriMenuItem2 = new JMenuItem();
        this.loadFromFileMI2 = new JMenuItem();
        this.pasteMenuItem2 = new JMenuItem();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.OpenMenuItem = new JMenuItem();
        this.SaveAsMenuItem = new JMenuItem();
        this.exportResultsMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.showHelpMenuItem = new JMenuItem();
        this.jPanel1 = new JPanel();
        this.postRunPopupMenu = new JPopupMenu();
        this.copyScriptUri = new JMenuItem();
        this.rerunScriptMenuItem = new JMenuItem();
        this.copyValueMenuItem = new JMenuItem();
        this.goButton = new JButton();
        this.param1ScrollPane = new JScrollPane();
        this.param1Values = new JTextArea();
        this.param2ScrollPane = new JScrollPane();
        this.param2Values = new JTextArea();
        this.dataSetSelector1 = new DataSetSelector();
        this.messageLabel = new JLabel();
        this.jLabel1 = new JLabel();
        this.param1NameCB = new JComboBox();
        this.param2NameCB = new JComboBox();
        this.closeButton = new JButton();
        this.generateButton1 = new JButton();
        this.generateButton2 = new JButton();
        this.writeCheckBox = new JCheckBox();
        this.writeFilenameCB = new JComboBox();
        this.progressPanel = new JPanel();
        this.editParamsButton = new JButton();
        this.pngWalkToolButton = new JButton();
        this.cancelButton = new JButton();
        this.deleteDirectoryButton = new JButton();
        this.activeFocusCB = new JCheckBox();
        this.jList2.setModel((ListModel<String>)new AbstractListModel<String>(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public String getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jList2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                RunBatchTool.this.jList2MouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jList2);
        this.generateMenuItem1.setText("Generate...");
        this.generateMenuItem1.setToolTipText("Generate items for list");
        this.generateMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunBatchTool.this.generateMenuItem1ActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.generateMenuItem1);
        this.loadUriMenuItem.setText("Load Events File...");
        this.loadUriMenuItem.setToolTipText("Load a list of time ranges from an events file.");
        this.loadUriMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunBatchTool.this.loadUriMenuItemActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.loadUriMenuItem);
        this.loadFromFileMI.setText("Load from File...");
        this.loadFromFileMI.setToolTipText("Load lines from file into this text area");
        this.loadFromFileMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunBatchTool.this.loadFromFileMIActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.loadFromFileMI);
        this.pasteMenuItem.setText("Paste");
        this.pasteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunBatchTool.this.pasteMenuItemActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.pasteMenuItem);
        this.jLabel2.setText("Time Range:");
        this.timeRangeComboBox.setEditable(true);
        this.timeRangeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Jun 2000", "2000", "2000-01-01/03-01", "2000-2016"}));
        this.timeFormatComboBox.setEditable(true);
        this.timeFormatComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"$Y-$m-$d", "$Y", "$Y-$m", "$Y_$j", "$Y-$m-$dT$H/PT1H", "$Y-$m-$dT$(H;delta=6)/PT6H", "$Y-$m-$dT$H$M/PT1M", "$Y-$m-$dT$H$M$S/PT1S", "$(o;id=rbspa-pp)"}));
        this.timeFormatComboBox.setToolTipText("Use the droplist to select from options, and make edits if necessary.");
        this.jLabel3.setText("Time Format:");
        GroupLayout timeRangesPanelLayout = new GroupLayout(this.timeRangesPanel);
        this.timeRangesPanel.setLayout(timeRangesPanelLayout);
        timeRangesPanelLayout.setHorizontalGroup(timeRangesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(timeRangesPanelLayout.createSequentialGroup().addGroup(timeRangesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.timeRangeComboBox, 0, -1, Short.MAX_VALUE).addGroup(timeRangesPanelLayout.createSequentialGroup().addGroup(timeRangesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel2)).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.timeFormatComboBox, GroupLayout.Alignment.TRAILING, 0, 220, Short.MAX_VALUE)).addContainerGap()));
        timeRangesPanelLayout.setVerticalGroup(timeRangesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(timeRangesPanelLayout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.timeRangeComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.timeFormatComboBox, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.generateMenuItem2.setText("Generate...");
        this.generateMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunBatchTool.this.generateMenuItem2ActionPerformed(evt);
            }
        });
        this.jPopupMenu2.add(this.generateMenuItem2);
        this.loadUriMenuItem2.setText("Load Events File...");
        this.loadUriMenuItem2.setToolTipText("Load a list of time ranges from an events file.");
        this.loadUriMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunBatchTool.this.loadUriMenuItem2ActionPerformed(evt);
            }
        });
        this.jPopupMenu2.add(this.loadUriMenuItem2);
        this.loadFromFileMI2.setText("Load from File");
        this.loadFromFileMI2.setToolTipText("Load lines from file into this text area");
        this.loadFromFileMI2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunBatchTool.this.loadFromFileMI2ActionPerformed(evt);
            }
        });
        this.jPopupMenu2.add(this.loadFromFileMI2);
        this.pasteMenuItem2.setText("Paste");
        this.pasteMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunBatchTool.this.pasteMenuItem2ActionPerformed(evt);
            }
        });
        this.jPopupMenu2.add(this.pasteMenuItem2);
        this.fileMenu.setText("File");
        this.OpenMenuItem.setText("Open batch file...");
        this.OpenMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunBatchTool.this.OpenMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.OpenMenuItem);
        this.SaveAsMenuItem.setText("Save Batch File As...");
        this.SaveAsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunBatchTool.this.SaveAsMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.SaveAsMenuItem);
        this.exportResultsMenuItem.setText("Export Results...");
        this.exportResultsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunBatchTool.this.exportResultsMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exportResultsMenuItem);
        this.menuBar.add(this.fileMenu);
        this.helpMenu.setText("Help");
        this.showHelpMenuItem.setText("Show Help Manual in Browser");
        this.showHelpMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunBatchTool.this.showHelpMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.showHelpMenuItem);
        this.menuBar.add(this.helpMenu);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        this.copyScriptUri.setText("Copy Script URI");
        this.copyScriptUri.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunBatchTool.this.copyScriptUriActionPerformed(evt);
            }
        });
        this.postRunPopupMenu.add(this.copyScriptUri);
        this.rerunScriptMenuItem.setText("Re-Run Script");
        this.rerunScriptMenuItem.setToolTipText("Re run the script with these arguments");
        this.rerunScriptMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunBatchTool.this.rerunScriptMenuItemActionPerformed(evt);
            }
        });
        this.postRunPopupMenu.add(this.rerunScriptMenuItem);
        this.copyValueMenuItem.setText("Copy Value to Clipboard");
        this.copyValueMenuItem.setToolTipText("");
        this.copyValueMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunBatchTool.this.copyValueMenuItemActionPerformed(evt);
            }
        });
        this.postRunPopupMenu.add(this.copyValueMenuItem);
        this.goButton.setText("Go!");
        this.goButton.setToolTipText("Run the batch processes, holding shift to run independent processes in parallel.");
        this.goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunBatchTool.this.goButtonActionPerformed(evt);
            }
        });
        this.param1Values.setColumns(20);
        this.param1Values.setRows(5);
        this.param1Values.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                RunBatchTool.this.param1ValuesMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                RunBatchTool.this.param1ValuesMouseReleased(evt);
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                RunBatchTool.this.param1ValuesMouseClicked(evt);
            }
        });
        this.param1ScrollPane.setViewportView(this.param1Values);
        this.param2Values.setColumns(20);
        this.param2Values.setRows(5);
        this.param2Values.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                RunBatchTool.this.param2ValuesMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                RunBatchTool.this.param2ValuesMouseReleased(evt);
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                RunBatchTool.this.param2ValuesMouseClicked(evt);
            }
        });
        this.param2ScrollPane.setViewportView(this.param2Values);
        this.messageLabel.setText("Load up those parameters and hit Go!");
        this.jLabel1.setText("<html>This tool generates inputs for scripts, running through a series of inputs.  First load the script with the green \"play\" button, then specify the parameter name and values to assign, and optionally a second parameter.  Each value of the second parameter is run for each value of the first.  Use the inspect button to set values for any other parameters. Right-click within the values areas to generate values.");
        this.jLabel1.setVerticalAlignment(1);
        this.param1NameCB.setEditable(true);
        this.param1NameCB.setModel(new DefaultComboBoxModel<String>(new String[]{" "}));
        this.param1NameCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                RunBatchTool.this.param1NameCBItemStateChanged(evt);
            }
        });
        this.param1NameCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunBatchTool.this.param1NameCBActionPerformed(evt);
            }
        });
        this.param2NameCB.setEditable(true);
        this.param2NameCB.setModel(new DefaultComboBoxModel<String>(new String[]{" "}));
        this.param2NameCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                RunBatchTool.this.param2NameCBItemStateChanged(evt);
            }
        });
        this.param2NameCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunBatchTool.this.param2NameCBActionPerformed(evt);
            }
        });
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunBatchTool.this.closeButtonActionPerformed(evt);
            }
        });
        this.generateButton1.setText("Generate...");
        this.generateButton1.setToolTipText("Generate items for list");
        this.generateButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunBatchTool.this.generateButton1ActionPerformed(evt);
            }
        });
        this.generateButton2.setText("Generate...");
        this.generateButton2.setToolTipText("Generate items for list");
        this.generateButton2.setEnabled(false);
        this.generateButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunBatchTool.this.generateButton2ActionPerformed(evt);
            }
        });
        this.writeCheckBox.setText("Write:");
        this.writeCheckBox.setToolTipText("After each iteration, write the file, where each $x is replaced with the parameter value.  The number \nof $x fields must match the number of parameters controlled.  Note the script name and its arguments\nare embedded within each .vap, and the pngwalk tool can be used to relaunch the script for any run.");
        this.writeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunBatchTool.this.writeCheckBoxActionPerformed(evt);
            }
        });
        this.writeFilenameCB.setEditable(true);
        this.writeFilenameCB.setModel(new DefaultComboBoxModel<String>(new String[]{"/tmp/ap/$x.png", "/tmp/ap/$x_$x.png", "/tmp/ap/$x_$x.png", "/tmp/ap/$x_$x_$x.png", "/tmp/ap/$x_$x_$x_$x.png", "/tmp/ap/$x.pdf", "/tmp/ap/$x_$x.pdf", "/tmp/ap/%s_%s.pdf", "/tmp/ap/%s_%s_%02d.png", " ", " "}));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.writeCheckBox, (Property)ELProperty.create((String)"${selected}"), this.writeFilenameCB, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.writeFilenameCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunBatchTool.this.writeFilenameCBActionPerformed(evt);
            }
        });
        GroupLayout progressPanelLayout = new GroupLayout(this.progressPanel);
        this.progressPanel.setLayout(progressPanelLayout);
        progressPanelLayout.setHorizontalGroup(progressPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 497, Short.MAX_VALUE));
        progressPanelLayout.setVerticalGroup(progressPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 51, Short.MAX_VALUE));
        this.editParamsButton.setText("Edit Parameter Values");
        this.editParamsButton.setEnabled(false);
        this.editParamsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunBatchTool.this.editParamsButtonActionPerformed(evt);
            }
        });
        this.pngWalkToolButton.setText("PNG Walk Tool");
        this.pngWalkToolButton.setToolTipText("Open template in the PNG Walk Tool");
        this.pngWalkToolButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunBatchTool.this.pngWalkToolButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.setToolTipText("cancel task.  Note tasks must be checking for cancel to terminate immediately.");
        this.cancelButton.setEnabled(false);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunBatchTool.this.cancelButtonActionPerformed(evt);
            }
        });
        this.deleteDirectoryButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/trashcan.png")));
        this.deleteDirectoryButton.setToolTipText("Delete files in directory");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.writeCheckBox, (Property)ELProperty.create((String)"${selected}"), (Object)this.deleteDirectoryButton, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.deleteDirectoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunBatchTool.this.deleteDirectoryButtonActionPerformed(evt);
            }
        });
        this.activeFocusCB.setText("Active focus");
        this.activeFocusCB.setEnabled(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE).addComponent((Component)this.dataSetSelector1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.param1NameCB, -2, 246, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.generateButton1)).addComponent(this.param1ScrollPane)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.param2ScrollPane).addGroup(layout.createSequentialGroup().addComponent(this.param2NameCB, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.generateButton2)))).addGroup(layout.createSequentialGroup().addComponent(this.activeFocusCB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.writeCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.writeFilenameCB, -2, 238, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteDirectoryButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pngWalkToolButton)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.messageLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.progressPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 74, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.goButton, -2, 62, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton)).addComponent(this.editParamsButton, GroupLayout.Alignment.TRAILING)))).addContainerGap()));
        layout.linkSize(0, this.generateButton1, this.generateButton2);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, 63, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.dataSetSelector1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.param1NameCB, -2, -1, -2).addComponent(this.param2NameCB, -2, -1, -2).addComponent(this.generateButton1).addComponent(this.generateButton2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.param1ScrollPane, -1, 279, Short.MAX_VALUE).addComponent(this.param2ScrollPane)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.writeCheckBox).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.writeFilenameCB, -2, -1, -2).addComponent(this.pngWalkToolButton).addComponent(this.deleteDirectoryButton, -2, 22, -2)).addComponent(this.activeFocusCB)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(22, 22, 22).addComponent(this.editParamsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.goButton).addComponent(this.closeButton).addComponent(this.cancelButton))).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.messageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.progressPanel, -2, -1, -2))).addContainerGap()));
        this.bindingGroup.bind();
    }

    private void goButtonActionPerformed(ActionEvent evt) {
        if (!this.goButton.isEnabled()) {
            return;
        }
        this.goButton.setEnabled(false);
        this.activeFocusCB.setEnabled(true);
        this.messageLabel.setText("Setting up to run jobs...");
        Runnable run = () -> {
            try {
                String scriptName = this.dataSetSelector1.getValue();
                this.dom.getController().getApplicationModel().addRecent(scriptName);
                Preferences prefs = this.prefs;
                int threadCount = prefs.getInt(PREF_THREAD_COUNT, 8);
                String warning = "<html><p>Multiple processes can run at the same time, generally<br>the number of threads should equal the number of CPU cores, beyond that<br>performance will probably not scale.  Note older versions of<br>Autoplot, before v2025a_6, did not support this fully.<br><br>Proceed?</p></html>";
                JPanel p = new JPanel();
                p.setLayout(new BoxLayout(p, 1));
                JLabel l = new JLabel(warning);
                l.setAlignmentX(0.0f);
                l.setHorizontalAlignment(2);
                p.add(l);
                JPanel p2 = new JPanel();
                p2.setLayout(new BoxLayout(p2, 0));
                JFormattedTextField tf = new JFormattedTextField((Object)threadCount);
                p2.add(new JLabel("Number of threads:"));
                p2.add(tf);
                int size = tf.getFont().getSize();
                tf.setMaximumSize(new Dimension(size * 5, size * 2));
                tf.setPreferredSize(new Dimension(size * 5, size * 2));
                p2.setAlignmentX(0.0f);
                p.add(p2);
                if (0 == WindowManager.showConfirmDialog(this.param1NameCB, (Object)p, (String)"Multi-Thread warning", (int)2)) {
                    threadCount = Integer.parseInt(tf.getText());
                    prefs.putInt(PREF_THREAD_COUNT, threadCount);
                    this.doIt(threadCount);
                } else {
                    this.goButton.setEnabled(true);
                }
            }
            catch (IOException ex) {
                this.messageLabel.setText(ex.getMessage());
            }
        };
        new Thread(run, "runBatch").start();
    }

    private void param1ValuesMouseClicked(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.jPopupMenu1.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void param1ValuesMousePressed(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.jPopupMenu1.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void param1ValuesMouseReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.jPopupMenu1.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void generateMenuItem1ActionPerformed(ActionEvent evt) {
        this.doGenerate(this.param1NameCB, this.param1Values);
    }

    private void param2ValuesMouseClicked(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.jPopupMenu2.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void generateMenuItem2ActionPerformed(ActionEvent evt) {
        this.doGenerate(this.param2NameCB, this.param2Values);
    }

    private void param2ValuesMousePressed(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.jPopupMenu2.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void param2ValuesMouseReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.jPopupMenu2.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        ProgressMonitor mon;
        Window w = SwingUtilities.getWindowAncestor(this);
        if (!(w instanceof JDialog)) {
            logger.warning("untested code might leave hidden windows...");
        }
        if ((mon = this.monitor) != null) {
            mon.cancel();
        }
        w.setVisible(false);
    }

    private void loadUriMenuItemAction(JTextArea paramValues) {
        DataSetSelector eventsDataSetSelector = new DataSetSelector();
        ArrayList<Bookmark> deft = new ArrayList<Bookmark>();
        deft.add(new Bookmark.Item("https://autoplot.org/data/event/simpleEvent.txt"));
        org.autoplot.bookmarks.Util.loadRecent("eventsRecent", eventsDataSetSelector, deft);
        if (0 == WindowManager.showConfirmDialog((Component)this, (Object)eventsDataSetSelector, (String)"Load Events", (int)2)) {
            try {
                QDataSet ds = org.autoplot.jythonsupport.Util.getDataSet((String)eventsDataSetSelector.getValue());
                ds = Ops.createEvents((QDataSet)ds);
                Units tu = (Units)((QDataSet)ds.property("BUNDLE_1")).property("UNITS", 0);
                StringBuilder ss = new StringBuilder();
                for (int i = 0; i < ds.length(); ++i) {
                    QDataSet tr = ds.slice(i).trim(0, 2);
                    tr = Ops.putProperty((QDataSet)tr, (String)"UNITS", (Object)tu);
                    ss.append(DataSetUtil.asDatumRange((QDataSet)tr).toString()).append("\n");
                }
                paramValues.setText(ss.toString());
            }
            catch (Exception ex) {
                Logger.getLogger(RunBatchTool.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void loadUriMenuItemActionPerformed(ActionEvent evt) {
        this.loadUriMenuItemAction(this.param1Values);
    }

    private void generateButton2ActionPerformed(ActionEvent evt) {
        this.doGenerate(this.param2NameCB, this.param2Values);
    }

    private void generateButton1ActionPerformed(ActionEvent evt) {
        this.doGenerate(this.param1NameCB, this.param1Values);
    }

    private void param1NameCBItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            if (this.param1NameCB.getSelectedIndex() == this.param1NameCB.getItemCount() - 1) {
                this.doSelectMultiple(this.param1NameCB, this.param1NameCB.getSelectedItem());
                return;
            }
            boolean present = this.param1NameCB.getSelectedItem().toString().trim().length() > 0;
            this.generateButton1.setEnabled(present);
            this.generateMenuItem1.setEnabled(present);
            this.param1ScrollPane.getViewport().setView(this.param1Values);
            this.param2ScrollPane.getViewport().setView(this.param2Values);
            this.messageLabel.setText("Load up those parameters and hit Go!");
        }
    }

    private void param2NameCBItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            if (this.param2NameCB.getSelectedIndex() == this.param2NameCB.getItemCount() - 1) {
                this.doSelectMultiple(this.param2NameCB, this.param2NameCB.getSelectedItem());
                return;
            }
            boolean present = this.param2NameCB.getSelectedItem().toString().trim().length() > 0;
            this.generateButton2.setEnabled(present);
            this.generateMenuItem2.setEnabled(present);
        }
    }

    private void OpenMenuItemActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileNameExtensionFilter("Batch Parameters", "batch"));
        chooser.setDialogType(0);
        Preferences prefs = Preferences.userNodeForPackage(RunBatchTool.class);
        String s = prefs.get("batch", null);
        if (s != null) {
            chooser.setSelectedFile(new File(s));
        }
        if (0 == chooser.showOpenDialog(this)) {
            File f = chooser.getSelectedFile();
            prefs.put("batch", f.toString());
            Runnable run = () -> {
                try {
                    this.loadBatchFile(f);
                }
                catch (IOException | JSONException ex) {
                    JOptionPane.showMessageDialog(this, "Unable to open file. " + ex.getMessage());
                }
            };
            new Thread(run).start();
        }
    }

    private void SaveAsMenuItemActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileNameExtensionFilter("Batch Parameters", "batch"));
        chooser.setDialogType(0);
        Preferences prefs = Preferences.userNodeForPackage(RunBatchTool.class);
        String s = prefs.get("batch", null);
        if (s != null) {
            chooser.setSelectedFile(new File(s));
        }
        if (0 == chooser.showSaveDialog(this)) {
            File ff = chooser.getSelectedFile();
            if (!ff.getName().endsWith(".batch")) {
                ff = new File(ff.getAbsolutePath() + ".batch");
            }
            File f = ff;
            prefs.put("batch", f.toString());
            Runnable run = () -> {
                try {
                    this.saveFile(f);
                }
                catch (IOException | JSONException ex) {
                    JOptionPane.showMessageDialog(this, "Unable to save file. " + ex.getMessage());
                }
            };
            new Thread(run).start();
        }
    }

    private void exportResultsMenuItemActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.addChoosableFileFilter(new FileNameExtensionFilter("CSV Files", "csv"));
        chooser.addChoosableFileFilter(new FileNameExtensionFilter("JSON Files", "json"));
        chooser.setDialogType(1);
        Preferences prefs = Preferences.userNodeForPackage(RunBatchTool.class);
        String s = prefs.get("export", null);
        if (s != null) {
            chooser.setSelectedFile(new File(s));
        }
        if (0 == chooser.showSaveDialog(this)) {
            File f;
            File ff = chooser.getSelectedFile();
            if (!ff.getName().endsWith(".csv") && !ff.getName().endsWith(".json")) {
                ff = new File(ff.getAbsolutePath() + ".csv");
            }
            this.resultsFile = f = ff;
            if (this.results == null) {
                String msg = "Output will be written to " + f + ".pending and moved after the run.";
                JOptionPane.showMessageDialog(this, msg);
                return;
            }
            prefs.put("export", f.toString());
            String message0 = this.messageLabel.getText();
            Runnable run = () -> {
                try {
                    if (this.results == null) {
                        this.exportResults(f, this.resultsPending);
                        JOptionPane.showMessageDialog(this, "pending results saved to " + f);
                    } else {
                        this.exportResults(f, this.results);
                        JOptionPane.showMessageDialog(this, "data saved to " + f);
                    }
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(this, "Unable to save file. " + ex.getMessage());
                }
                catch (JSONException ex) {
                    JOptionPane.showMessageDialog(this, "Unable to save file because of JSON exception " + ex.getMessage());
                }
                this.messageLabel.setText(message0);
            };
            String msg = "writing to " + ff + "...";
            this.messageLabel.setText("<html>" + msg + "<html>");
            new Thread(run).start();
        }
    }

    private void showHelpMenuItemActionPerformed(ActionEvent evt) {
        AutoplotUtil.openBrowser("https://github.com/autoplot/documentation/blob/main/md/batch.md");
    }

    private void loadFromFileMIActionPerformed(ActionEvent evt) {
        this.doLoadFromFile(this.param1Values);
    }

    private void loadFromFileMI2ActionPerformed(ActionEvent evt) {
        this.doLoadFromFile(this.param2Values);
    }

    private void pasteMenuItemActionPerformed(ActionEvent evt) {
        try {
            String pasteMe = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
            this.param1Values.setText(pasteMe);
        }
        catch (UnsupportedFlavorException | IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    private void pasteMenuItem2ActionPerformed(ActionEvent evt) {
        try {
            String pasteMe = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
            this.param2Values.setText(pasteMe);
        }
        catch (UnsupportedFlavorException | IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    private void editParamsButtonActionPerformed(ActionEvent evt) {
        this.switchToEditableList();
        this.editParamsButton.setEnabled(false);
        this.goButton.setEnabled(true);
    }

    private void pngWalkToolButtonActionPerformed(ActionEvent evt) {
        String template = this.writeFilenameCB.getSelectedItem().toString();
        template = this.convertStringFormatToUriTemplate(template);
        PngWalkTool.start(template, SwingUtilities.getWindowAncestor(this));
    }

    private void jList2MouseClicked(MouseEvent evt) {
        this.jPopupMenu2.show(this, evt.getX(), evt.getY());
    }

    private void writeFilenameCBActionPerformed(ActionEvent evt) {
        this.checkNumberOfParams();
    }

    private void copyScriptUriActionPerformed(ActionEvent evt) {
        JLabel p = this.getSelectedLabel();
        String uri = this.jobs.get(p);
        if (uri != null) {
            System.err.println(uri);
            StringSelection stringSelection = new StringSelection(uri);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
            this.messageLabel.setText("URI copied to system clipboard.");
        } else {
            this.messageLabel.setText("Unable to find script URI.");
            System.err.println("internal error...");
            StringSelection stringSelection = new StringSelection("Internal error...");
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
        }
    }

    private void rerunScriptMenuItemActionPerformed(ActionEvent evt) {
        JLabel jLabel1 = this.getSelectedLabel();
        if (!this.param2NameCB.getSelectedItem().toString().trim().equals("")) {
            JOptionPane.showMessageDialog(this, "Rerun is not supported with two arguments");
            return;
        }
        String argName = this.param1NameCB.getSelectedItem().toString();
        String argValue = jLabel1.getText();
        String scriptName = this.dataSetSelector1.getValue();
        URISplit split = URISplit.parse((String)scriptName);
        this.pwd = split.path;
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("dom", this.dom);
        env.put("PWD", this.pwd);
        try {
            File scriptFile = DataSetURI.getFile((String)split.file, (ProgressMonitor)new AlertNullProgressMonitor());
            String script = this.readScript(scriptFile);
            LinkedHashMap params = URISplit.parseParams((String)split.params);
            Map parms = Util.getParams(env, (String)script, (Map)params, (ProgressMonitor)new NullProgressMonitor());
            Runnable run = () -> this.doOneJob(jLabel1, scriptFile, parms, params, argName, argValue, (ProgressMonitor)new NullProgressMonitor());
            jLabel1.setIcon(ICON_WORKING);
            new Thread(run, "run-batch-0").start();
        }
        catch (IOException ex) {
            Logger.getLogger(RunBatchTool.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        ProgressMonitor mon = this.monitor;
        if (mon != null) {
            mon.cancel();
        }
        this.cancelButton.setEnabled(false);
    }

    private void copyValueMenuItemActionPerformed(ActionEvent evt) {
        JLabel p = this.getSelectedLabel();
        String argValue = p.getText();
        System.err.println(argValue);
        StringSelection stringSelection = new StringSelection(argValue);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
        this.messageLabel.setText("Copied to system clipboard: " + argValue);
    }

    private void loadUriMenuItem2ActionPerformed(ActionEvent evt) {
        this.loadUriMenuItemAction(this.param2Values);
    }

    private void param1NameCBActionPerformed(ActionEvent evt) {
        this.checkNumberOfParams();
    }

    private void param2NameCBActionPerformed(ActionEvent evt) {
        this.checkNumberOfParams();
    }

    private void writeCheckBoxActionPerformed(ActionEvent evt) {
        this.checkNumberOfParams();
    }

    private void deleteDirectoryButtonActionPerformed(ActionEvent evt) {
        String s = this.writeFilenameCB.getSelectedItem().toString();
        int i = FileStorageModel.splitIndex((String)s);
        int i2 = s.indexOf("%");
        if (i2 > -1 && (i == -1 || i2 < i)) {
            i = i2 = s.lastIndexOf("/", i2);
        }
        if (i > -1) {
            File dir = new File(s.substring(0, i));
            if (JOptionPane.showConfirmDialog(this, "<html>Delete files and directory<br>" + dir + "?", "Delete Directory", 2) == 0 && !FileUtil.deleteFileTree((File)dir)) {
                JOptionPane.showMessageDialog(this, "Unable to delete directory");
            }
        } else {
            JOptionPane.showMessageDialog(this, "Unable to find directory (looking for forward slashes)");
        }
    }

    private void doLoadFromFile(JTextArea paramValues) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileNameExtensionFilter("Text Files", "txt"));
        chooser.setDialogType(0);
        Preferences prefs = Preferences.userNodeForPackage(RunBatchTool.class);
        String s = prefs.get("textfile", null);
        if (s != null) {
            chooser.setSelectedFile(new File(s));
        }
        if (0 == chooser.showOpenDialog(this)) {
            this.readFromFile(chooser, paramValues);
            prefs.put("textfile", chooser.getSelectedFile().toString());
        }
    }

    private void readFromFile(JFileChooser chooser, JTextArea paramValues) {
        StringBuilder b = new StringBuilder();
        try (BufferedReader read = new BufferedReader(new FileReader(chooser.getSelectedFile()));){
            String l = read.readLine();
            while (l != null) {
                if (l.trim().length() > 0) {
                    b.append(l).append("\n");
                }
                l = read.readLine();
            }
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, null, ex);
        }
        Runnable run = () -> paramValues.setText(b.toString());
        SwingUtilities.invokeLater(run);
    }

    private void exportResults(File f, JSONObject results) throws IOException, JSONException {
        if (results == null) {
            return;
        }
        if (f.getName().endsWith(".json")) {
            String sresults = results.toString(3);
            FileUtil.writeStringToFile((File)f, (String)sresults);
        } else {
            RunBatchTool.appendResultsPendingCSV(f, results, results.getJSONArray("results"), 0, results.getJSONArray("results").length());
        }
    }

    private void loadBatchFile(File f) throws IOException, JSONException {
        int i;
        StringBuilder sb;
        JSONArray ja;
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalArgumentException("don't call from event thread");
        }
        String src = FileUtil.readFileToString((File)f);
        JSONObject jo = new JSONObject(src);
        HashMap<String, String> params = new HashMap<String, String>();
        String scriptName1 = jo.getString("script");
        String scriptName = scriptName1 = scriptName1.replaceAll("\\%\\{PWD\\}", f.getParentFile().getCanonicalPath());
        params.put("script", scriptName);
        Runnable run = () -> {
            this.dataSetSelector1.setValue(scriptName);
            this.doPlayButton();
        };
        try {
            SwingUtilities.invokeAndWait(run);
        }
        catch (InterruptedException | InvocationTargetException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        params.put("param1", jo.getString("param1"));
        params.put("param2", jo.getString("param2"));
        Object o = jo.get("param1Values");
        if (o instanceof String) {
            params.put("param1Values", (String)o);
        } else if (o instanceof JSONArray) {
            ja = (JSONArray)o;
            sb = new StringBuilder();
            for (i = 0; i < ja.length(); ++i) {
                if (i > 0) {
                    sb.append("\n");
                }
                sb.append(ja.getString(i));
            }
            params.put("param1Values", sb.toString());
        } else {
            throw new IllegalArgumentException("bad format in file " + f);
        }
        o = jo.get("param2Values");
        if (o instanceof String) {
            params.put("param2Values", (String)o);
        } else if (o instanceof JSONArray) {
            ja = (JSONArray)o;
            sb = new StringBuilder();
            for (i = 0; i < ja.length(); ++i) {
                if (i > 0) {
                    sb.append("\n");
                }
                sb.append(ja.getString(i));
            }
            params.put("param2Values", sb.toString());
        } else {
            throw new IllegalArgumentException("bad format in file " + f);
        }
        run = () -> {
            this.param1NameCB.setSelectedItem(params.get("param1"));
            this.param2NameCB.setSelectedItem(params.get("param2"));
            this.param1Values.setText((String)params.get("param1Values"));
            this.param2Values.setText((String)params.get("param2Values"));
        };
        try {
            SwingUtilities.invokeAndWait(run);
        }
        catch (InterruptedException | InvocationTargetException ex) {
            Logger.getLogger(RunBatchTool.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void saveFile(File f) throws IOException, JSONException {
        boolean newBatchFormat = System.getProperty("newBatchFileFormat", "false").equals("true");
        JSONObject jo = new JSONObject();
        String script = this.dataSetSelector1.getValue();
        if (script.startsWith("script:")) {
            script = script.substring(7);
        }
        jo.put("script", (Object)script);
        jo.put("param1", (Object)this.param1NameCB.getSelectedItem().toString());
        jo.put("param2", (Object)this.param2NameCB.getSelectedItem().toString());
        String s1 = this.param1Values.getText().trim();
        if (newBatchFormat) {
            JSONArray ja = new JSONArray();
            if (s1.length() > 0) {
                String[] ss = s1.split("\n", -2);
                for (int i = 0; i < ss.length; ++i) {
                    ja.put(i, (Object)ss[i]);
                }
            }
            jo.put("param1Values", (Object)ja);
        } else {
            jo.put("param1Values", (Object)s1);
        }
        String s2 = this.param2Values.getText().trim();
        if (newBatchFormat) {
            JSONArray ja = new JSONArray();
            if (s2.length() > 0) {
                String[] ss = s2.split("\n", -2);
                for (int i = 0; i < ss.length; ++i) {
                    ja.put(i, (Object)ss[i]);
                }
            }
            jo.put("param2Values", (Object)ja);
        } else {
            jo.put("param2Values", (Object)s2);
        }
        String src = jo.toString(4);
        FileUtil.writeStringToFile((File)f, (String)src);
    }

    private String[] doGenerateOne(Param pd) {
        String[] ss = null;
        if (pd.type == 'T' || pd.type == 'S' && UnitsUtil.isTimeLocation((Units)((DatumRange)pd.deft).getUnits())) {
            try {
                if (pd.constraints.containsKey("format")) {
                    String format = (String)pd.constraints.get("format");
                    this.timeFormatComboBox.setSelectedItem(format);
                }
                if (pd.constraints.containsKey("min") && pd.constraints.containsKey("max")) {
                    try {
                        String minMax = Ops.datumRange((Object)(pd.constraints.get("min") + "/" + pd.constraints.get("max"))).toString();
                        this.timeRangeComboBox.setSelectedItem(minMax);
                    }
                    catch (IllegalArgumentException ex) {
                        ex.printStackTrace();
                    }
                }
                if (AutoplotUtil.showConfirmDialog(this, this.timeRangesPanel, "Generate Time Ranges", 2) == 0) {
                    String timeRange = this.timeRangeComboBox.getSelectedItem().toString();
                    String template = this.timeFormatComboBox.getSelectedItem().toString();
                    this.prefs.put("lastTimeRange", timeRange);
                    this.prefs.put("lastTimeFormat", template);
                    Pattern p = Pattern.compile("\\$\\(o[,;]id=([a-zA-Z\\-_]+)\\)");
                    Matcher m = p.matcher(template);
                    if (m.matches()) {
                        String id = m.group(1);
                        template = "orbit:" + id + ":" + template;
                    }
                    ss = ScriptContext.generateTimeRanges(template, timeRange);
                }
            }
            catch (ParseException ex) {
                Logger.getLogger(RunBatchTool.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (pd.enums != null) {
            final JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            String label = pd.label;
            if (pd.doc != null) {
                label = "<html>" + label + ", <i>" + pd.doc + "</i>";
            }
            panel.add(new JLabel(label));
            List labels = (List)pd.constraints.get("labels");
            for (int i = 0; i < pd.enums.size(); ++i) {
                String ll = pd.enums.get(i).toString();
                if (labels != null) {
                    ll = ll + ": " + (String)labels.get(i);
                }
                JCheckBox checkBox = new JCheckBox(ll);
                checkBox.setSelected(true);
                panel.add(checkBox);
            }
            AbstractAction a = new AbstractAction("clear all"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (Component c : panel.getComponents()) {
                        if (!(c instanceof JCheckBox)) continue;
                        ((JCheckBox)c).setSelected(false);
                    }
                }
            };
            panel.add(new JButton(a));
            JScrollPane scrollPane = new JScrollPane(panel);
            scrollPane.setPreferredSize(new Dimension(300, 400));
            scrollPane.setMaximumSize(new Dimension(300, 400));
            scrollPane.getVerticalScrollBar().setUnitIncrement(panel.getFont().getSize());
            if (AutoplotUtil.showConfirmDialog(this, scrollPane, "Select from Values", 2) == 0) {
                ArrayList<String> theList = new ArrayList<String>();
                for (Component c : panel.getComponents()) {
                    if (!(c instanceof JCheckBox) || !((JCheckBox)c).isSelected()) continue;
                    String t = ((JCheckBox)c).getText();
                    int icolon = t.indexOf(": ");
                    if (icolon > -1) {
                        t = t.substring(0, icolon);
                    }
                    theList.add(t);
                }
                ss = theList.toArray(new String[theList.size()]);
            }
        } else if (pd.type == 'F') {
            boolean isInt;
            JPanel panel = new JPanel();
            int h = panel.getFont().getSize() * 2;
            panel.setLayout(new BoxLayout(panel, 1));
            panel.setAlignmentX(0.0f);
            String label = pd.label;
            if (pd.doc != null) {
                label = "<html>" + label + ", <i>" + pd.doc + "</i>";
            }
            panel.add(new JLabel(label));
            JTextField min = new JTextField("");
            min.setAlignmentX(0.0f);
            min.setMaximumSize(new Dimension(h * 10, h));
            JTextField max = new JTextField("");
            max.setAlignmentX(0.0f);
            max.setMaximumSize(new Dimension(h * 10, h));
            JTextField step = new JTextField("");
            step.setAlignmentX(0.0f);
            step.setMaximumSize(new Dimension(h * 10, h));
            min.setText(String.valueOf(pd.deft));
            if (pd.deft instanceof Integer) {
                step.setText("1");
                isInt = true;
            } else {
                max.setText(String.valueOf(((Number)pd.deft).doubleValue() + 10.0));
                step.setText("0.1");
                isInt = false;
            }
            if (pd.constraints.containsKey("min")) {
                min.setText(String.valueOf(pd.constraints.get("min")));
            }
            if (pd.constraints.containsKey("max")) {
                max.setText(String.valueOf(pd.constraints.get("max")));
            }
            panel.add(new JLabel("Minimum: "));
            panel.add(min);
            panel.add(new JLabel("Maximum: "));
            panel.add(max);
            panel.add(new JLabel("Step Size: "));
            panel.add(step);
            while (AutoplotUtil.showConfirmDialog(this, panel, "Select range", 2) == 0) {
                ArrayList<String> theList = new ArrayList<String>();
                double dmin = Double.parseDouble(min.getText());
                double dmax = Double.parseDouble(max.getText());
                double dstep = Double.parseDouble(step.getText());
                if (dstep <= 0.0 || dmax < dmin) continue;
                int ni = (int)Math.round((dmax - dmin) / dstep) + 1;
                int digits = (int)Math.floor(Math.log10(dstep));
                double dfac = 1.0;
                String spec = digits < 0 ? "%." + -digits + "f" : "%.0f";
                for (int i = 0; i < ni; ++i) {
                    double x = (dmin + dstep * (double)i) * dfac;
                    theList.add(isInt ? String.valueOf((int)Math.round(x)) : String.format(spec, x));
                }
                ss = theList.toArray(new String[theList.size()]);
                break;
            }
        } else if (pd.type == 'R') {
            String deft = String.valueOf(pd.deft);
            File f = null;
            try {
                URISplit split = URISplit.parse((String)deft);
                if (split.path != null && split.path.startsWith("file:")) {
                    f = new File(split.path.substring(5));
                }
            }
            catch (IllegalArgumentException split) {
                // empty catch block
            }
            JFileChooser cf = new JFileChooser();
            if (f != null) {
                cf.setCurrentDirectory(f);
            }
            cf.setMultiSelectionEnabled(true);
            if (cf.showOpenDialog(this) == 0) {
                File[] ff = cf.getSelectedFiles();
                ss = new String[ff.length];
                for (int i = 0; i < ff.length; ++i) {
                    ss[i] = "file:" + ff[i].toString();
                }
            }
        } else if (pd.type == 'L' || pd.type == 'M' || pd.type == 'A' && "file".equals(pd.constraints.get("stringType"))) {
            String deft = String.valueOf(pd.deft);
            File f = null;
            try {
                URISplit split = URISplit.parse((String)deft);
                if (split.path != null && split.path.startsWith("file:")) {
                    f = new File(split.path.substring(5));
                }
            }
            catch (IllegalArgumentException split) {
                // empty catch block
            }
            String lastItem = "";
            if (lastItem.length() > 0) {
                int i = lastItem.lastIndexOf(10);
                lastItem = lastItem.substring(i + 1);
                URISplit split = URISplit.parse((String)lastItem);
                if (split.path != null && split.path.startsWith("file:")) {
                    f = new File(split.path.substring(5));
                }
            }
            JFileChooser cf = new JFileChooser();
            if (f != null) {
                cf.setCurrentDirectory(f);
            }
            cf.setMultiSelectionEnabled(true);
            if (cf.showOpenDialog(this) == 0) {
                File[] ff = cf.getSelectedFiles();
                ss = new String[ff.length];
                if (pd.type == 'L') {
                    for (int i = 0; i < ff.length; ++i) {
                        ss[i] = "file:" + ff[i].toString();
                    }
                } else if (pd.type == 'M' || pd.type == 'A' && "file".equals(pd.constraints.get("stringType"))) {
                    for (int i = 0; i < ff.length; ++i) {
                        ss[i] = ff[i].toString();
                    }
                }
            }
        } else {
            JTextArea ta = new JTextArea(5, 20);
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 1));
            p.add(new JLabel("GUI is not available, manually enter values:"));
            p.add(ta);
            if (0 == JOptionPane.showConfirmDialog(this, p, "Manually enter", 2)) {
                ss = ta.getText().split("\n");
            } else {
                return null;
            }
        }
        return ss;
    }

    private void doGenerateMulti(JComboBox cb, JTextArea ta) {
        String p = cb.getSelectedItem().toString();
        String[] pps = RunBatchTool.maybeSplitMultiParam(p);
        char splitChar = p.charAt(pps[0].length());
        String[][] rs1 = new String[pps.length][];
        for (int i = 0; i < pps.length; ++i) {
            p = pps[i].trim();
            try {
                Param pd = this.getParamDescription(p);
                rs1[i] = this.doGenerateOne(pd);
                if (rs1[i] != null) continue;
                return;
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "bad parameter name");
            }
        }
        StringBuilder sb = new StringBuilder();
        if (pps.length == 2) {
            for (String item0 : rs1[0]) {
                for (String item1 : rs1[1]) {
                    sb.append(item0);
                    sb.append(splitChar);
                    sb.append(item1);
                    sb.append("\n");
                }
            }
        } else if (pps.length == 3) {
            for (String item0 : rs1[0]) {
                for (String item1 : rs1[1]) {
                    for (String item2 : rs1[2]) {
                        sb.append(item0);
                        sb.append(splitChar);
                        sb.append(item1);
                        sb.append(splitChar);
                        sb.append(item2);
                        sb.append("\n");
                    }
                }
            }
        }
        ta.setText(sb.toString());
        this.messageLabel.setText("Load up those parameters and hit Go!");
        this.switchToEditableList();
    }

    private void doGenerate(JComboBox cb, JTextArea ta) {
        if (cb.getSelectedItem() == null) {
            return;
        }
        String p = cb.getSelectedItem().toString();
        if ((p = p.trim()).length() > 0) {
            try {
                String[] pps = RunBatchTool.maybeSplitMultiParam(p);
                if (pps != null) {
                    this.doGenerateMulti(cb, ta);
                    return;
                }
                Param pd = this.getParamDescription(p);
                if (pd == null) {
                    return;
                }
                String[] ss = this.doGenerateOne(pd);
                if (ss == null) {
                    logger.fine("cancelled");
                } else {
                    StringBuilder b = new StringBuilder();
                    for (String s : ss) {
                        b.append(s).append("\n");
                    }
                    ta.setText(b.toString());
                    this.messageLabel.setText("Load up those parameters and hit Go!");
                    this.switchToEditableList();
                }
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "bad parameter name");
            }
        }
    }

    private Param getParamDescription(String name) throws IOException {
        String scriptName = this.dataSetSelector1.getValue();
        URISplit split = URISplit.parse((String)scriptName);
        if (!split.file.endsWith(".jy")) {
            JOptionPane.showMessageDialog(this, "script must end in .jy: " + scriptName);
            return null;
        }
        this.pwd = split.path;
        LinkedHashMap params = URISplit.parseParams((String)split.params);
        HashMap<String, Object> env = new HashMap<String, Object>();
        File scriptFile = DataSetURI.getFile((String)split.file, (ProgressMonitor)new NullProgressMonitor());
        String script = this.readScript(scriptFile);
        env.put("dom", this.dom);
        env.put("PWD", this.pwd);
        Map parms = Util.getParams(env, (String)script, (Map)params, (ProgressMonitor)new NullProgressMonitor());
        Param p = (Param)parms.get(name);
        return p;
    }

    private static void setParam(InteractiveInterpreter interp, String pwd, Param paramDescription, String paramName, String f1) throws IOException {
        if (paramDescription == null) {
            throw new IllegalArgumentException("expected to see parameter description!");
        }
        switch (paramDescription.type) {
            case 'R': 
            case 'U': {
                if (f1.startsWith("'") && f1.endsWith("'") && f1.length() > 1) {
                    f1 = f1.substring(1, f1.length() - 1);
                }
                URISplit split = URISplit.parse((String)f1);
                URI uri = split.path == null ? DataSetURI.getResourceURI((String)(pwd + f1)) : DataSetURI.getResourceURI((String)f1);
                interp.set("_apuri", (Object)uri);
                interp.exec("autoplot2025.params['" + paramName + "']=_apuri");
                break;
            }
            case 'L': {
                interp.exec("autoplot2025.params['" + paramName + "']=URL('" + f1 + "')");
                break;
            }
            case 'M': {
                interp.exec("from java.io import File");
                interp.exec("autoplot2025.params['" + paramName + "']=File('" + f1 + "')");
                break;
            }
            case 'A': {
                if (f1.startsWith("'") && f1.endsWith("'") && f1.length() > 1) {
                    f1 = f1.substring(1, f1.length() - 1);
                }
                interp.exec("autoplot2025.params['" + paramName + "']='" + f1 + "'");
                break;
            }
            case 'T': {
                try {
                    DatumRange timeRange = DatumRangeUtil.parseTimeRange((String)f1);
                    interp.set("_apdr", (Object)timeRange);
                    interp.exec("autoplot2025.params['" + paramName + "']=_apdr");
                }
                catch (ParseException ex) {
                    Logger.getLogger(RunBatchTool.class.getName()).log(Level.SEVERE, null, ex);
                }
                break;
            }
            default: {
                interp.exec("autoplot2025.params['" + paramName + "']=" + f1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readScript(File f) throws FileNotFoundException, IOException {
        StringBuilder build = new StringBuilder();
        try (BufferedReader r = new BufferedReader(new FileReader(f));){
            String line = r.readLine();
            while (line != null) {
                build.append(line).append("\n");
                line = r.readLine();
            }
        }
        return build.toString();
    }

    private String doWrite(String f1, String f2, String uri, Application dom) throws IOException {
        String[] ss;
        if (!this.writeCheckBox.isSelected()) {
            return null;
        }
        String template = this.writeFilenameCB.getSelectedItem().toString();
        Preferences prefs = Preferences.userNodeForPackage(RunBatchTool.class);
        prefs.put("lastTemplate", template);
        template = template.replaceAll("\\$x", "%s");
        f1 = f1.replaceAll("/", "_");
        f2 = f2.replaceAll("/", "_");
        f1 = f1.replaceAll(" ", "_");
        f2 = f2.replaceAll(" ", "_");
        f1 = f1.replaceAll(":", "_");
        f2 = f2.replaceAll(":", "_");
        ArrayList<String> argList = new ArrayList<String>();
        if (f1.contains(";")) {
            for (String s : ss = f1.split("\\;", -2)) {
                argList.add(s);
            }
        } else if (f1.trim().length() > 0) {
            argList.add(f1);
        }
        if (f2.contains(";")) {
            for (String s : ss = f2.split("\\;", -2)) {
                argList.add(s);
            }
        } else if (f2.trim().length() > 0) {
            argList.add(f2);
        }
        ss = template.split("\\%");
        boolean packArgments = false;
        if (argList.size() != ss.length - 1) {
            if (ss.length == 3) {
                packArgments = true;
            } else {
                throw new IllegalArgumentException("PNG template and number of parameters don't match");
            }
        }
        Object[] args = new Object[argList.size()];
        block6: for (int i = 0; i < argList.size(); ++i) {
            int c;
            if (i > ss.length) {
                System.err.println("Do somethng here");
            }
            String spec = packArgments ? "x" : ss[i + 1];
            int idx = 0;
            int n = c = spec.length() > 0 ? (int)spec.charAt(0) : 32;
            while (idx < spec.length() && (c == 45 || c == 46 || Character.isDigit((char)c))) {
                c = spec.length() > 0 ? (int)spec.charAt(++idx) : 32;
            }
            if (idx == spec.length()) {
                throw new IllegalArgumentException("expected to see non-digit in template after %");
            }
            char letter = spec.charAt(idx);
            if (letter == 's') {
                args[i] = argList.get(i);
                continue;
            }
            switch (letter) {
                case 'd': {
                    args[i] = Integer.parseInt((String)argList.get(i));
                    continue block6;
                }
                case 'e': 
                case 'f': {
                    args[i] = Double.parseDouble((String)argList.get(i));
                    continue block6;
                }
                default: {
                    args[i] = argList.get(i);
                }
            }
        }
        String s = packArgments ? String.format(template, f1, f2) : String.format(template, args);
        if ((s = s.replaceAll(" ", "_")).endsWith(".png")) {
            BufferedImage bufferedImage = dom.getController().getScriptContext().writeToBufferedImage();
            LinkedHashMap<String, String> metadata = new LinkedHashMap<String, String>();
            metadata.put("ScriptURI", uri);
            if (dom != null) {
                metadata.put("plotInfo", dom.getController().getApplicationModel().canvas.getImageMetadata());
            }
            dom.getController().getScriptContext().writeToPng(bufferedImage, s, metadata);
        } else if (s.endsWith(".pdf")) {
            dom.getController().getScriptContext().writeToPdf(s);
        }
        return s;
    }

    private void switchToEditableList() {
        this.messageLabel.setText("Load up those parameters and hit Go!");
        this.param1ScrollPane.getViewport().setView(this.param1Values);
        this.param2ScrollPane.getViewport().setView(this.param2Values);
    }

    private void selectRecord(int irec) {
        for (int i = 0; i < this.param1JLabels.length; ++i) {
            this.param1JLabels[i].setBackground(Color.white);
            this.param1JLabels[i].setBorder(BorderFactory.createEmptyBorder());
        }
        if (irec > -1) {
            this.param1JLabels[irec].setBackground(Color.GRAY);
            this.param1JLabels[irec].setBorder(BorderFactory.createLineBorder(Color.black));
        }
    }

    private JPanel switchListToIconLabels(List<JLabel> jobs1, String[] ff1) {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        for (String f : ff1) {
            JLabel l = new JLabel(f);
            l.setIcon(ICON_QUEUED);
            p.add(l);
            jobs1.add(l);
        }
        JScrollPane scrollp = new JScrollPane(p);
        scrollp.getVerticalScrollBar().setUnitIncrement(scrollp.getFont().getSize());
        scrollp.setPreferredSize(new Dimension(640, 640));
        scrollp.setMaximumSize(new Dimension(640, 640));
        this.messageLabel.setText(RUNNING_LABEL_MOUSEOVER);
        return p;
    }

    private static String htmlize(String txt) {
        String[] ss = txt.split("\n");
        StringBuilder sb = new StringBuilder("<html>\n");
        int iline = 0;
        for (String s : ss) {
            sb.append(s);
            sb.append("<br>\n");
            if (++iline <= 50) continue;
            sb.append("&npsp;&nbsp;(").append(ss.length - 50).append(" more lines...)<br>");
            break;
        }
        sb.append("</html>");
        return sb.toString();
    }

    private static String htmlize(String txt, String stderr) {
        String[] ss;
        StringBuilder sb = new StringBuilder("<html>\n");
        int iline = 0;
        if (txt.trim().length() > 0) {
            for (String s : ss = txt.split("\n")) {
                sb.append(s);
                sb.append("<br>\n");
                if (++iline <= 50) continue;
                sb.append("&npsp;&nbsp;(").append(ss.length - 50).append(" more lines...)<br>");
                break;
            }
            if (stderr.trim().length() > 0) {
                sb.append("<b>stderr:</b><br>");
            }
        }
        if (stderr.trim().length() > 0) {
            for (String s : ss = stderr.split("\n")) {
                sb.append(s);
                sb.append("<br>\n");
                if (++iline <= 50) continue;
                sb.append("&npsp;&nbsp;(").append(ss.length - 50).append(" more lines...)<br>");
                break;
            }
        }
        sb.append("</html>");
        return sb.toString();
    }

    private static String[] maybeSplitMultiParam(String param) {
        if (param.contains("|")) {
            return param.split("\\|", -2);
        }
        if (param.contains(",")) {
            return param.split(",", -2);
        }
        if (param.contains(";")) {
            return param.split(";", -2);
        }
        return null;
    }

    public void doIt() throws IOException {
        this.doIt(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject doOneJob(JLabel jobLabel, File scriptFile, Map<String, Param> parms, Map<String, String> params, String paramName, String paramValue, final ProgressMonitor monitor) {
        URISplit split = URISplit.parse((String)scriptFile.toString());
        paramValue = paramValue.trim();
        paramName = paramName.trim();
        JSONObject runResults = new JSONObject();
        try {
            Object v;
            this.dom.getController().getScriptContext();
            ApplicationModel appmodel = new ApplicationModel();
            appmodel.addDasPeersToAppAndWait();
            Application myDom = appmodel.getDom();
            ScriptContext2023 scriptContext = new ScriptContext2023();
            myDom.getController().setScriptContext(scriptContext);
            if (!scriptContext.isModelInitialized()) {
                scriptContext.setApplicationModel(appmodel);
                scriptContext.setView(null);
                scriptContext._setDefaultApp(this.dom.getController().maybeGetApplicatonGUI());
            }
            myDom.getController().getScriptContext();
            NullProgressMonitor myMonitor = new NullProgressMonitor(){

                public boolean isCancelled() {
                    return monitor.isCancelled();
                }
            };
            InteractiveInterpreter interp = JythonUtil.createInterpreter(true, false, myDom, (ProgressMonitor)myMonitor);
            interp.exec(JythonRefactory.fixImports((String)"import autoplot2025"));
            LinkedHashMap<String, Object> scriptParams = new LinkedHashMap<String, Object>();
            scriptParams.putAll(params);
            if (monitor.isCancelled()) {
                return null;
            }
            jobLabel.setIcon(ICON_WORKING);
            if (this.activeFocusCB.isSelected()) {
                SwingUtilities.invokeLater(() -> {
                    JViewport vp = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, jobLabel);
                    try {
                        Rectangle r = SwingUtilities.convertRectangle(jobLabel.getParent(), jobLabel.getBounds(), vp);
                        vp.scrollRectToVisible(r);
                    }
                    catch (Error error) {
                        // empty catch block
                    }
                });
            }
            interp.set("PWD", (Object)split.path);
            String[] paramNames = RunBatchTool.maybeSplitMultiParam(paramName);
            if (paramNames != null) {
                char splitc = paramName.charAt(paramNames[0].length());
                String[] paramValues = paramValue.trim().split("\\" + splitc);
                for (int j = 0; j < paramNames.length; ++j) {
                    String p = paramNames[j].trim();
                    v = paramValues[j].trim();
                    if (!parms.containsKey(p)) {
                        if (p.trim().length() == 0) {
                            throw new IllegalArgumentException("param1Name not set");
                        }
                        throw new IllegalArgumentException("param not found: " + p);
                    }
                    RunBatchTool.setParam(interp, this.pwd, parms.get(p), p, (String)v);
                    runResults.put(p, v);
                    scriptParams.put(p, v);
                }
            } else {
                if (!parms.containsKey(paramName) && paramName.length() == 0) {
                    throw new IllegalArgumentException("param1Name not set");
                }
                for (Map.Entry<String, String> e : params.entrySet()) {
                    String pname = e.getKey();
                    if (parms.get(pname) == null) continue;
                    RunBatchTool.setParam(interp, this.pwd, parms.get(pname), pname, e.getValue());
                }
                RunBatchTool.setParam(interp, this.pwd, parms.get(paramName), paramName, paramValue);
                runResults.put(paramName, (Object)paramValue);
                scriptParams.put(paramName, paramValue);
            }
            if (this.param2NameCB.getSelectedItem().toString().trim().length() == 0) {
                long t0 = System.currentTimeMillis();
                String stdout = "";
                try {
                    ByteArrayOutputStream outbaos = new ByteArrayOutputStream();
                    v = null;
                    try {
                        this.param1ScrollPane.scrollRectToVisible(jobLabel.getBounds());
                        interp.setOut((OutputStream)outbaos);
                        interp.execfile(JythonRefactory.fixImports((InputStream)new FileInputStream(scriptFile), (String)scriptFile.getName()), scriptFile.getName());
                        String uri = URISplit.format((String)"script", (String)split.resourceUri.toString(), scriptParams);
                        if (this.writeCheckBox.isSelected()) {
                            runResults.put("writeFile", (Object)this.doWrite(paramValue, "", uri, myDom));
                        }
                        jobLabel.setIcon(ICON_OKAY);
                        this.jobs.put(jobLabel, uri);
                        stdout = new String(outbaos.toByteArray(), "US-ASCII");
                    }
                    catch (Throwable throwable) {
                        v = throwable;
                        throw throwable;
                    }
                    finally {
                        if (outbaos != null) {
                            if (v != null) {
                                try {
                                    outbaos.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)v).addSuppressed(throwable);
                                }
                            } else {
                                outbaos.close();
                            }
                        }
                    }
                }
                catch (IOException | RuntimeException | JSONException ex) {
                    String msg = ex.toString().intern();
                    runResults.put("result", (Object)msg);
                    jobLabel.setIcon(ICON_PROB);
                }
                finally {
                    runResults.put("stdout", (Object)stdout);
                    runResults.put("executionTime", System.currentTimeMillis() - t0);
                    System.out.println(runResults.getString("stdout"));
                }
                if (jobLabel.getIcon() == ICON_OKAY) {
                    jobLabel.setToolTipText(RunBatchTool.htmlize(runResults.getString("stdout")));
                } else {
                    jobLabel.setToolTipText(RunBatchTool.htmlize(runResults.getString("stdout"), runResults.getString("result")));
                }
                JSONObject copy = new JSONObject(runResults, JSONObject.getNames((JSONObject)runResults));
                return copy;
            }
            throw new IllegalArgumentException("only one argument for multi-threaded version");
        }
        catch (IOException | RuntimeException | JSONException ex) {
            Logger.getLogger(RunBatchTool.class.getName()).log(Level.SEVERE, null, ex);
            jobLabel.setIcon(ICON_PROB);
            jobLabel.setToolTipText(RunBatchTool.htmlize(ex.toString()));
            String[] names = JSONObject.getNames((JSONObject)runResults);
            if (names != null) {
                JSONObject copy = new JSONObject(runResults, names);
                return copy;
            }
            return runResults;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doItMultiThreadOneArgument(int threadCount) throws IOException {
        DasProgressPanel monitor = DasProgressPanel.createComponent((String)"");
        this.progressPanel.add(monitor.getComponent());
        this.monitor = monitor;
        monitor.started();
        this.jobs.clear();
        ArrayList<JLabel> jobs1 = new ArrayList<JLabel>();
        ArrayList<JLabel> jobs2 = new ArrayList<JLabel>();
        this.editParamsButton.setEnabled(true);
        AtomicInteger threadCounter = new AtomicInteger(0);
        ThreadFactory tf = r -> new Thread(r, "run-batch-" + threadCounter.incrementAndGet());
        ThreadPoolExecutor executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(threadCount, tf);
        ArrayDeque durationsMillis = new ArrayDeque();
        String scriptName = this.dataSetSelector1.getValue();
        URISplit split = URISplit.parse((String)scriptName);
        this.pwd = split.path;
        if (!split.file.endsWith(".jy")) {
            JOptionPane.showMessageDialog(this, "script must end in .jy: " + scriptName);
            return;
        }
        String[] ff1 = this.param1Values.getText().split("\n");
        JPanel p = this.switchListToIconLabels(jobs1, ff1);
        for (int i = 0; i < jobs1.size(); ++i) {
            int fi = i;
            ((JLabel)jobs1.get(i)).addMouseListener(this.getJobsMouseListener(fi, jobs1, jobs2));
        }
        this.param1JLabels = jobs1.toArray(new JLabel[jobs1.size()]);
        this.param1ScrollPane.getViewport().setView(p);
        if (this.param2Values.getText().trim().length() > 0) {
            ff1 = this.param2Values.getText().split("\n");
            p = this.switchListToIconLabels(jobs2, ff1);
            this.param2ScrollPane.getViewport().setView(p);
        }
        try {
            String template;
            ff1 = this.param1Values.getText().split("\n");
            monitor.setTaskSize((long)ff1.length);
            monitor.started();
            LinkedHashMap splitParams = URISplit.parseParams((String)split.params);
            HashMap<String, Object> env = new HashMap<String, Object>();
            env.put("dom", this.dom);
            env.put("PWD", this.pwd);
            File scriptFile = DataSetURI.getFile((String)split.file, (ProgressMonitor)monitor.getSubtaskMonitor("download script"));
            String script = this.readScript(scriptFile);
            Map parms = Util.getParams(env, (String)script, (Map)splitParams, (ProgressMonitor)new NullProgressMonitor());
            InteractiveInterpreter interp = JythonUtil.createInterpreter(true, false, this.dom, null);
            interp.exec(JythonRefactory.fixImports((String)"import autoplot2025"));
            ParametersFormPanel pfp = new ParametersFormPanel();
            pfp.doVariables(env, scriptFile, (Map)splitParams, null);
            splitParams.entrySet().forEach(ent -> {
                try {
                    pfp.getFormData().implement((PythonInterpreter)interp, (String)ent.getKey(), (String)ent.getValue());
                }
                catch (ParseException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            });
            if (this.writeCheckBox.isSelected() && !(template = this.writeFilenameCB.getSelectedItem().toString()).endsWith(".pdf") && !template.endsWith(".png")) {
                AutoplotUtil.showConfirmDialog(this, "write template must end in .pdf or .png", "Write Template Error", 0);
                return;
            }
            JSONObject jo = new JSONObject();
            JSONArray ja = new JSONArray();
            jo.put("results", (Object)ja);
            String param1 = this.param1NameCB.getSelectedItem() != null ? this.param1NameCB.getSelectedItem().toString().trim() : "";
            String param2 = this.param2NameCB.getSelectedItem() != null ? this.param2NameCB.getSelectedItem().toString().trim() : "";
            param1 = this.cleanupMultiParam(param1);
            param2 = this.cleanupMultiParam(param2);
            JSONArray paramsJson = new JSONArray();
            paramsJson.put(0, (Object)param1);
            if (param2.length() > 0) {
                paramsJson.put(1, (Object)param2);
            }
            jo.put("params", (Object)paramsJson);
            monitor.setTaskSize((long)ff1.length);
            monitor.started();
            monitor.setTaskProgress(0L);
            int i1 = 0;
            int exportResultsWritten = 0;
            AtomicInteger I1 = new AtomicInteger(0);
            boolean showEta = "true".equals(System.getProperty("RunBatchTool.eta", "true"));
            String[] stringArray = ff1;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String f1;
                String final_f1 = f1 = stringArray[i];
                String final_param1 = param1;
                LinkedHashMap final_params = splitParams;
                JLabel jobLabel = (JLabel)jobs1.get(i1);
                JSONObject frunResults = new JSONObject();
                ja.put(i1, (Object)frunResults);
                String uri = URISplit.format((String)"script", (String)split.resourceUri.toString(), Collections.singletonMap(final_param1, final_f1));
                this.jobs.put(jobLabel, uri);
                Runnable runOne = () -> {
                    if (monitor.isCancelled()) {
                        return;
                    }
                    long t0 = System.currentTimeMillis();
                    JSONObject runResults = this.doOneJob(jobLabel, scriptFile, parms, final_params, final_param1, final_f1, monitor.getSubtaskMonitor(final_f1));
                    if (showEta) {
                        durationsMillis.addLast(System.currentTimeMillis() - t0);
                    }
                    if (runResults == null) {
                        return;
                    }
                    Iterator i = runResults.keys();
                    while (i.hasNext()) {
                        String k = (String)i.next();
                        try {
                            frunResults.put(k, runResults.get(k));
                        }
                        catch (JSONException ex) {
                            logger.log(Level.SEVERE, null, ex);
                        }
                    }
                    if (monitor.isFinished()) {
                        logger.fine("monitor reports being finished though it shouldn't have been.");
                    } else {
                        monitor.setTaskProgress((long)I1.incrementAndGet());
                    }
                };
                executor.execute(runOne);
                ++i1;
            }
            long lastWrite = System.currentTimeMillis();
            long lastReport = System.currentTimeMillis();
            long messageNumber = 0L;
            while (!(executor.getActiveCount() == 0 && I1.intValue() == ff1.length || monitor.isCancelled())) {
                long t = System.currentTimeMillis();
                if (this.resultsFile != null && t - lastWrite > 10000L) {
                    if (!this.resultsFile.getName().endsWith(".json")) {
                        File pendingResultsFile = new File(this.resultsFile.getAbsolutePath() + ".pending");
                        int completed = I1.intValue();
                        int count = completed - exportResultsWritten;
                        RunBatchTool.appendResultsPendingCSV(pendingResultsFile, jo, ja, exportResultsWritten, count);
                        String msg = "wrote records " + exportResultsWritten + "-" + completed + " to " + this.resultsFile.getAbsolutePath() + ".pending";
                        this.messageLabel.setToolTipText(msg);
                        this.messageLabel.setText("<html>" + msg + "</html>");
                        exportResultsWritten = completed;
                    }
                    lastWrite = t;
                }
                if (showEta && t - lastReport > 3000L) {
                    String report;
                    while (durationsMillis.size() > 12) {
                        long completed = (Long)durationsMillis.removeFirst();
                    }
                    long timeFor12Jobs = 0L;
                    if (durationsMillis.size() >= 12) {
                        Iterator it = durationsMillis.descendingIterator();
                        for (int i = 0; i < 12; ++i) {
                            timeFor12Jobs += ((Long)it.next()).longValue();
                        }
                    }
                    if (++messageNumber % 4L > 0L) {
                        long jobsRemaining = executor.getTaskCount() - executor.getCompletedTaskCount();
                        if (timeFor12Jobs > 0L) {
                            Datum eta = Units.milliseconds.createDatum((double)(jobsRemaining * timeFor12Jobs) / 12.0 / (double)executor.getCorePoolSize());
                            eta = DatumUtil.asOrderOneUnits((Datum)eta);
                            String seta = String.format("%.2f%s", eta.value(), eta.getUnits());
                            Datum avgDuration = Units.milliseconds.createDatum((double)timeFor12Jobs / 12.0);
                            avgDuration = DatumUtil.asOrderOneUnits((Datum)avgDuration);
                            String savgDuration = String.format("%.2f%s", avgDuration.value(), avgDuration.getUnits());
                            report = String.format("%d remaining, avg %s, eta %s", jobsRemaining, savgDuration, seta);
                        } else {
                            report = String.format("%d jobs, %d remaining", ff1.length, jobsRemaining);
                        }
                    } else {
                        report = RUNNING_LABEL_MOUSEOVER;
                    }
                    this.messageLabel.setText(report);
                    lastReport = t;
                }
                JSONObject pendingResults = new JSONObject(jo.toString());
                pendingResults.put("results", (Object)new JSONArray(ja.toString()));
            }
            if (monitor.isCancelled()) {
                executor.shutdownNow();
            }
            jo.put("results", (Object)ja);
            this.results = jo;
            if (this.resultsFile != null) {
                RunBatchTool.appendResultsPendingCSV(this.resultsFile, jo, ja, 0, ja.length());
                this.messageLabel.setText("completed, wrote (" + ja.length() + ") to " + this.resultsFile.getAbsolutePath());
            }
        }
        catch (JSONException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        finally {
            if (!this.messageLabel.getText().startsWith("completed, wrote")) {
                this.messageLabel.setText("Jobs are complete, click above to edit.");
            }
            this.messageLabel.setToolTipText("");
            if (!monitor.isFinished()) {
                monitor.finished();
            }
            this.monitor = null;
            this.goButton.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIt(int multiThread) throws IOException {
        String pp2;
        this.jobs.clear();
        String string = pp2 = this.param2NameCB.getSelectedItem() != null ? this.param2NameCB.getSelectedItem().toString().trim() : "";
        if (pp2.equals("") && multiThread > 0) {
            this.doItMultiThreadOneArgument(multiThread);
            return;
        }
        DasProgressPanel monitor = DasProgressPanel.createComponent((String)"");
        this.progressPanel.add(monitor.getComponent());
        this.monitor = monitor;
        ArrayList<JLabel> jobs1 = new ArrayList<JLabel>();
        ArrayList<JLabel> jobs2 = new ArrayList<JLabel>();
        this.editParamsButton.setEnabled(true);
        this.closeButton.setEnabled(false);
        this.cancelButton.setEnabled(true);
        String[] ff1 = this.param1Values.getText().split("\n");
        JPanel p = this.switchListToIconLabels(jobs1, ff1);
        for (int i = 0; i < jobs1.size(); ++i) {
            int fi = i;
            ((JLabel)jobs1.get(i)).addMouseListener(this.getJobsMouseListener(fi, jobs1, jobs2));
        }
        this.param1JLabels = jobs1.toArray(new JLabel[jobs1.size()]);
        this.param1ScrollPane.getViewport().setView(p);
        if (this.param2Values.getText().trim().length() > 0) {
            ff1 = this.param2Values.getText().split("\n");
            p = this.switchListToIconLabels(jobs2, ff1);
            this.param2ScrollPane.getViewport().setView(p);
        }
        try {
            String template;
            int i;
            String[] ss;
            String scriptName = this.dataSetSelector1.getValue();
            URISplit split = URISplit.parse((String)scriptName);
            this.pwd = split.path;
            if (!split.file.endsWith(".jy")) {
                JOptionPane.showMessageDialog(this, "script must end in .jy: " + scriptName);
                return;
            }
            String[] ff12 = this.param1Values.getText().split("\n");
            monitor.setTaskSize((long)ff12.length);
            monitor.started();
            LinkedHashMap params = URISplit.parseParams((String)split.params);
            HashMap<String, Object> env = new HashMap<String, Object>();
            env.put("dom", this.dom);
            env.put("PWD", this.pwd);
            File scriptFile = DataSetURI.getFile((String)split.file, (ProgressMonitor)monitor.getSubtaskMonitor("download script"));
            String script = this.readScript(scriptFile);
            Map parms = Util.getParams(env, (String)script, (Map)params, (ProgressMonitor)new NullProgressMonitor());
            int parameterCount = 0;
            String params1 = String.valueOf(this.param1NameCB.getSelectedItem());
            String params2 = String.valueOf(this.param2NameCB.getSelectedItem());
            ArrayList parameterDescriptionsList = new ArrayList();
            if (params1.contains(";")) {
                ss = params1.split("\\;", -2);
                parameterCount += ss.length;
                for (i = 0; i < ss.length; ++i) {
                    parameterDescriptionsList.add(parms.get(ss[i]));
                }
            } else {
                ++parameterCount;
                parameterDescriptionsList.add(parms.get(params1));
            }
            if (params2.contains(";")) {
                ss = params2.split("\\;", -2);
                parameterCount += ss.length;
                for (i = 0; i < ss.length; ++i) {
                    parameterDescriptionsList.add(parms.get(ss[i]));
                }
            } else {
                ++parameterCount;
                parameterDescriptionsList.add(parms.get(params2));
            }
            this.parameterDescriptions = parameterDescriptionsList.toArray(new Param[parameterDescriptionsList.size()]);
            if (this.writeCheckBox.isSelected() && !(template = this.writeFilenameCB.getSelectedItem().toString()).endsWith(".pdf") && !template.endsWith(".png")) {
                AutoplotUtil.showConfirmDialog(this, "write template must end in .pdf or .png", "Write Template Error", 0);
                return;
            }
            JSONObject jo = new JSONObject();
            JSONArray ja = new JSONArray();
            jo.put("results", (Object)ja);
            String param1 = this.param1NameCB.getSelectedItem() != null ? this.param1NameCB.getSelectedItem().toString().trim() : "";
            String param2 = this.param2NameCB.getSelectedItem() != null ? this.param2NameCB.getSelectedItem().toString().trim() : "";
            param1 = this.cleanupMultiParam(param1);
            param2 = this.cleanupMultiParam(param2);
            JSONArray paramsJson = new JSONArray();
            paramsJson.put(0, (Object)param1);
            if (param2.length() > 0) {
                paramsJson.put(1, (Object)param2);
            }
            jo.put("params", (Object)paramsJson);
            monitor.setTaskSize((long)ff12.length);
            int icount = 0;
            int i1 = 0;
            int exportResultsWritten = 0;
            long lastWrite = System.currentTimeMillis();
            for (String f1 : ff12) {
                block50: {
                    JSONObject runResults = new JSONObject();
                    LinkedHashMap<String, Object> scriptParams = new LinkedHashMap<String, Object>();
                    scriptParams.putAll(params);
                    try {
                        int i2;
                        InteractiveInterpreter interp;
                        if (monitor.isCancelled()) break;
                        monitor.setProgressMessage(f1);
                        monitor.setTaskProgress(monitor.getTaskProgress() + 1L);
                        if (f1.trim().length() == 0) {
                            ++i1;
                            continue;
                        }
                        JLabel jobLabel = (JLabel)jobs1.get(i1);
                        jobLabel.setIcon(ICON_WORKING);
                        if (this.activeFocusCB.isSelected()) {
                            SwingUtilities.invokeLater(() -> {
                                try {
                                    JViewport vp = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, jobLabel);
                                    Rectangle r = SwingUtilities.convertRectangle(jobLabel.getParent(), jobLabel.getBounds(), vp);
                                    vp.scrollRectToVisible(r);
                                }
                                catch (Error error) {
                                    // empty catch block
                                }
                            });
                        }
                        String uri = null;
                        if (this.param2NameCB.getSelectedItem().toString().trim().length() == 0) {
                            long t0 = System.currentTimeMillis();
                            interp = this.createInterpretter(env, scriptFile, params, split.path);
                            RunBatchTool.doSetParameter(this.param1NameCB, f1, parms, interp, this.pwd, runResults, scriptParams);
                            ByteArrayOutputStream outbaos = new ByteArrayOutputStream();
                            try {
                                this.param1ScrollPane.scrollRectToVisible(((JLabel)jobs1.get(i1)).getBounds());
                                interp.setOut((OutputStream)outbaos);
                                uri = URISplit.format((String)"script", (String)split.resourceUri.toString(), scriptParams);
                                this.jobs.put((JLabel)jobs1.get(i1), uri);
                                interp.execfile(JythonRefactory.fixImports((InputStream)new FileInputStream(scriptFile), (String)scriptFile.getName()), scriptFile.getName());
                                if (this.writeCheckBox.isSelected()) {
                                    Application myDom = (Application)env.get("dom");
                                    runResults.put("writeFile", (Object)this.doWrite(f1.trim(), "", uri, myDom));
                                }
                                ((JLabel)jobs1.get(i1)).setIcon(ICON_OKAY);
                            }
                            catch (IOException | RuntimeException | JSONException ex) {
                                String msg = ex.toString();
                                runResults.put("result", (Object)msg);
                                ((JLabel)jobs1.get(i1)).setIcon(ICON_PROB);
                            }
                            finally {
                                outbaos.close();
                                runResults.put("stdout", (Object)new String(outbaos.toByteArray(), "US-ASCII"));
                                runResults.put("executionTime", System.currentTimeMillis() - t0);
                                System.out.println(runResults.getString("stdout"));
                                this.jobs.put((JLabel)jobs1.get(i1), uri);
                            }
                            if (((JLabel)jobs1.get(i1)).getIcon() == ICON_OKAY) {
                                ((JLabel)jobs1.get(i1)).setToolTipText(RunBatchTool.htmlize(runResults.getString("stdout")));
                            } else {
                                ((JLabel)jobs1.get(i1)).setToolTipText(RunBatchTool.htmlize(runResults.getString("stdout"), runResults.getString("result")));
                            }
                            JSONObject copy = new JSONObject(runResults, JSONObject.getNames((JSONObject)runResults));
                            ja.put(icount, (Object)copy);
                            ++icount;
                            break block50;
                        }
                        String[] ff2 = this.param2Values.getText().split("\n");
                        for (i2 = 0; i2 < jobs2.size(); ++i2) {
                            ((JLabel)jobs2.get(i2)).setIcon(ICON_QUEUED);
                        }
                        i2 = 0;
                        String problemMessage = null;
                        for (String f2 : ff2) {
                            if (f2.trim().length() == 0) continue;
                            if (monitor.isCancelled()) break;
                            long t0 = System.currentTimeMillis();
                            interp = this.createInterpretter(env, scriptFile, params, split.path);
                            RunBatchTool.doSetParameter(this.param1NameCB, f1, parms, interp, this.pwd, runResults, scriptParams);
                            ByteArrayOutputStream outbaos = new ByteArrayOutputStream();
                            try {
                                RunBatchTool.doSetParameter(this.param2NameCB, f2, parms, interp, this.pwd, runResults, scriptParams);
                                ((JLabel)jobs2.get(i2)).setIcon(ICON_WORKING);
                                interp.setOut((OutputStream)outbaos);
                                uri = URISplit.format((String)"script", (String)split.resourceUri.toString(), scriptParams);
                                this.jobs.put((JLabel)jobs1.get(i1), uri);
                                this.jobs.put((JLabel)jobs2.get(i2), uri);
                                interp.execfile(JythonRefactory.fixImports((InputStream)new FileInputStream(scriptFile), (String)scriptFile.getName()), scriptFile.getName());
                                if (this.writeCheckBox.isSelected()) {
                                    Application myDom = (Application)env.get("dom");
                                    runResults.put("writeFile", (Object)this.doWrite(f1.trim(), f2.trim(), uri, myDom));
                                }
                                ((JLabel)jobs2.get(i2)).setIcon(ICON_OKAY);
                                runResults.put("result", (Object)"");
                            }
                            catch (IOException | RuntimeException | JSONException ex) {
                                String msg = ex.toString();
                                runResults.put("result", (Object)msg);
                                ((JLabel)jobs1.get(i1)).setIcon(ICON_PROB);
                                ((JLabel)jobs2.get(i2)).setIcon(ICON_PROB);
                                problemMessage = msg;
                            }
                            finally {
                                runResults.put("stdout", (Object)new String(outbaos.toByteArray(), "US-ASCII"));
                                runResults.put("executionTime", System.currentTimeMillis() - t0);
                                this.jobs.put((JLabel)jobs1.get(i1), uri);
                                this.jobs.put((JLabel)jobs2.get(i2), uri);
                                outbaos.close();
                                System.out.println(runResults.getString("stdout"));
                            }
                            if (((JLabel)jobs1.get(i1)).getIcon() != ICON_PROB) {
                                ((JLabel)jobs2.get(i2)).setToolTipText(RunBatchTool.htmlize(runResults.getString("stdout")));
                            } else {
                                String s = RunBatchTool.htmlize(runResults.getString("stdout"), runResults.getString("result"));
                                ((JLabel)jobs2.get(i2)).setToolTipText(s);
                                ((JLabel)jobs1.get(i1)).setToolTipText(s);
                            }
                            JSONObject copy = new JSONObject(runResults, JSONObject.getNames((JSONObject)runResults));
                            ja.put(icount, (Object)copy);
                            ++i2;
                            ++icount;
                        }
                        if (problemMessage == null) {
                            ((JLabel)jobs1.get(i1)).setIcon(ICON_OKAY);
                            ((JLabel)jobs1.get(i1)).setToolTipText(null);
                        }
                    }
                    catch (IOException | RuntimeException | JSONException ex) {
                        Logger.getLogger(RunBatchTool.class.getName()).log(Level.SEVERE, null, ex);
                        ((JLabel)jobs1.get(i1)).setIcon(ICON_PROB);
                        ((JLabel)jobs1.get(i1)).setToolTipText(RunBatchTool.htmlize(ex.toString()));
                    }
                }
                ++i1;
                if (this.resultsFile != null && System.currentTimeMillis() - lastWrite > 30000L) {
                    if (!this.resultsFile.getName().endsWith(".json")) {
                        File pendingResultsFile = new File(this.resultsFile.getAbsolutePath() + ".pending");
                        int nrec = ja.length() - exportResultsWritten;
                        RunBatchTool.appendResultsPendingCSV(pendingResultsFile, jo, ja, exportResultsWritten, ja.length() - exportResultsWritten);
                        this.messageLabel.setText("wrote (" + nrec + " more) to " + this.resultsFile.getAbsolutePath() + ".pending");
                    }
                    exportResultsWritten = icount;
                    lastWrite = System.currentTimeMillis();
                }
                this.resultsPending = new JSONObject(jo.toString());
                this.resultsPending.put("results", (Object)new JSONArray(ja.toString()));
            }
            jo.put("results", (Object)ja);
            this.results = jo;
            if (this.resultsFile != null) {
                RunBatchTool.appendResultsPendingCSV(this.resultsFile, jo, ja, 0, ja.length());
                this.messageLabel.setText("completed, wrote (" + ja.length() + ") to " + this.resultsFile.getAbsolutePath());
            }
        }
        catch (JSONException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        finally {
            if (!this.messageLabel.getText().startsWith("completed, wrote (")) {
                this.messageLabel.setText("Jobs are complete, click \"Edit Parameter Values\" to edit.");
            }
            if (!monitor.isFinished()) {
                monitor.finished();
            }
            this.monitor = null;
            this.cancelButton.setEnabled(false);
            this.closeButton.setEnabled(true);
            this.goButton.setEnabled(true);
        }
    }

    private static void doSetParameter(JComboBox cb, String paramValue, Map<String, Param> parms, InteractiveInterpreter interp, String pwd, JSONObject runResults, Map<String, Object> scriptParams) throws JSONException, IOException, IllegalArgumentException {
        String paramName = cb.getSelectedItem().toString().trim();
        String[] paramNames = RunBatchTool.maybeSplitMultiParam(paramName);
        if (paramNames != null) {
            char splitc = paramName.charAt(paramNames[0].length());
            String[] paramValues = paramValue.trim().split("\\" + splitc);
            for (int j = 0; j < paramNames.length; ++j) {
                String p = paramNames[j].trim();
                String v = paramValues[j].trim();
                if (!parms.containsKey(p)) {
                    if (p.trim().length() == 0) {
                        throw new IllegalArgumentException("param1Name not set");
                    }
                    throw new IllegalArgumentException("param not found: " + p);
                }
                RunBatchTool.setParam(interp, pwd, parms.get(p), p, v);
                runResults.put(p, (Object)v);
                scriptParams.put(p, v);
            }
        } else {
            if (!parms.containsKey(paramName) && paramName.trim().length() == 0) {
                throw new IllegalArgumentException("param1Name not set");
            }
            RunBatchTool.setParam(interp, pwd, parms.get(paramName), paramName, paramValue.trim());
            runResults.put(paramName, (Object)paramValue.trim());
            scriptParams.put(paramName, paramValue.trim());
        }
    }

    private MouseListener getJobsMouseListener(final int fi, final List<JLabel> jobs1, final List<JLabel> jobs2) {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    RunBatchTool.this.selectRecord(fi);
                    RunBatchTool.this.selectedLabel = (JLabel)jobs1.get(fi);
                    RunBatchTool.this.postRunPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                    return;
                }
                RunBatchTool.this.selectRecord(fi);
                RunBatchTool.this.selectedLabel = (JLabel)jobs1.get(fi);
                String param1 = (String)RunBatchTool.this.param1NameCB.getSelectedItem();
                if (RunBatchTool.this.results != null) {
                    String s = ((JLabel)jobs1.get(fi)).getText();
                    ArrayList<JSONObject> thisRow = new ArrayList<JSONObject>();
                    try {
                        JSONObject jo = RunBatchTool.this.results;
                        JSONArray ja = jo.getJSONArray("results");
                        for (int j = 0; j < ja.length(); ++j) {
                            JSONObject jo1 = ja.getJSONObject(j);
                            try {
                                if (!jo1.getString(param1).equals(s)) continue;
                                thisRow.add(jo1);
                                continue;
                            }
                            catch (JSONException ex) {
                                logger.warning(ex.getMessage());
                            }
                        }
                        if (jobs2.size() == thisRow.size()) {
                            for (int i = 0; i < thisRow.size(); ++i) {
                                JSONObject runResults = (JSONObject)thisRow.get(i);
                                String except = ((JSONObject)thisRow.get(i)).getString("result");
                                if (except.length() > 0) {
                                    ((JLabel)jobs2.get(i)).setIcon(ICON_PROB);
                                } else {
                                    ((JLabel)jobs2.get(i)).setIcon(ICON_OKAY);
                                }
                                if (((JLabel)jobs2.get(i)).getIcon() == ICON_OKAY) {
                                    ((JLabel)jobs2.get(i)).setToolTipText(RunBatchTool.htmlize(runResults.getString("stdout")));
                                    continue;
                                }
                                ((JLabel)jobs2.get(i)).setToolTipText(RunBatchTool.htmlize(runResults.getString("stdout"), runResults.getString("result")));
                            }
                        } else {
                            logger.fine("Nothing to do.");
                        }
                    }
                    catch (JSONException ex) {
                        Logger.getLogger(RunBatchTool.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    RunBatchTool.this.selectRecord(fi);
                    RunBatchTool.this.selectedLabel = (JLabel)jobs1.get(fi);
                    RunBatchTool.this.postRunPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                    return;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    RunBatchTool.this.selectRecord(fi);
                    RunBatchTool.this.selectedLabel = (JLabel)jobs1.get(fi);
                    RunBatchTool.this.postRunPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                    return;
                }
            }
        };
    }

    public static void main(String[] args) {
        JDialog dia = new JDialog();
        dia.setResizable(true);
        RunBatchTool mmm = new RunBatchTool(new Application());
        dia.setContentPane(mmm);
        dia.setJMenuBar(mmm.getMenuBar());
        mmm.param1NameCB.setSelectedItem("ie");
        mmm.dataSetSelector1.setValue("/home/jbf/ct/autoplot/script/demos/paramTypes.jy");
        mmm.param1Values.setText("1\n2\n3\n");
        dia.pack();
        dia.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void appendResultsPendingCSV(File pendingFile, JSONObject results, JSONArray resultsArray, int recordsWrittenAlready, int count) throws FileNotFoundException, IOException {
        boolean header = recordsWrittenAlready == 0;
        Class<RunBatchTool> clazz = RunBatchTool.class;
        synchronized (RunBatchTool.class) {
            try (PrintWriter out = new PrintWriter(new FileWriter(pendingFile, true));){
                StringBuilder record;
                if (resultsArray.length() == 0) {
                    logger.warning("no records in results");
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                    return;
                }
                JSONObject jo = resultsArray.getJSONObject(0);
                boolean hasOutputFile = jo.has("writeFile");
                JSONArray params = results.getJSONArray("params");
                if (header) {
                    record = new StringBuilder();
                    record.append("jobNumber");
                    for (int j = 0; j < params.length(); ++j) {
                        record.append(",");
                        record.append(params.get(j));
                    }
                    record.append(",").append("executionTime(ms)");
                    if (hasOutputFile) {
                        record.append(",").append("writeFile");
                    }
                    record.append(",").append("exception");
                    out.println(record.toString());
                }
                int stop = recordsWrittenAlready + count;
                for (int i = recordsWrittenAlready; i < stop; ++i) {
                    String resultString;
                    int inl;
                    jo = resultsArray.getJSONObject(i);
                    record = new StringBuilder();
                    record.append(i);
                    for (int j = 0; j < params.length(); ++j) {
                        record.append(",");
                        record.append(jo.get(params.getString(j)));
                    }
                    record.append(",").append(jo.get("executionTime"));
                    if (hasOutputFile) {
                        record.append(",").append(jo.get("writeFile"));
                    }
                    if ((inl = (resultString = jo.optString("result", "")).indexOf("\n")) >= 0) {
                        inl = resultString.indexOf("\n", inl + 1);
                    }
                    if (inl >= 0) {
                        inl = resultString.indexOf("\n", inl + 1);
                    }
                    if (inl >= 0) {
                        resultString = resultString.substring(0, inl).replaceAll("\n", " ").replaceAll(",", "");
                    }
                    record.append(",").append(resultString);
                    out.println(record.toString());
                }
                out.flush();
            }
            catch (JSONException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    private String cleanupMultiParam(String param1) {
        CharSequence[] ss = RunBatchTool.maybeSplitMultiParam(param1);
        if (ss == null) {
            return param1.trim();
        }
        char ch = param1.charAt(ss[0].length());
        for (int i = 0; i < ss.length; ++i) {
            ss[i] = ((String)ss[i]).trim();
        }
        return String.join((CharSequence)String.valueOf(ch), ss);
    }

    private void doSelectMultiple(JComboBox<String> param1NameCB, Object selectedItem) {
        JPanel p = new JPanel();
        ArrayList<JCheckBox> paramsCB = new ArrayList<JCheckBox>();
        p.setLayout(new BoxLayout(p, 1));
        int istart = ((String)param1NameCB.getModel().getElementAt(0)).trim().length() == 0 ? 1 : 0;
        for (int i = istart; i < param1NameCB.getModel().getSize() - 1; ++i) {
            String param = (String)param1NameCB.getModel().getElementAt(i);
            JCheckBox cb = new JCheckBox(param);
            p.add(cb);
            paramsCB.add(cb);
        }
        if (0 == WindowManager.showConfirmDialog(param1NameCB, (Object)p, (String)"Multiple Parameters", (int)2)) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < paramsCB.size(); ++i) {
                if (!((JCheckBox)paramsCB.get(i)).isSelected()) continue;
                if (b.length() > 0) {
                    b.append(";");
                }
                b.append(((JCheckBox)paramsCB.get(i)).getText());
            }
            Runnable run = () -> param1NameCB.setSelectedItem(b.toString());
            SwingUtilities.invokeLater(run);
        }
    }

    private JLabel getSelectedLabel() {
        return this.selectedLabel;
    }

    private InteractiveInterpreter createInterpretter(Map<String, Object> env, File scriptFile, Map<String, String> params, String pwd) throws IOException {
        Application dom = (Application)env.get("dom");
        InteractiveInterpreter interp = JythonUtil.createInterpreter(true, false, dom, null);
        interp.exec(JythonRefactory.fixImports((String)"import autoplot2025"));
        ParametersFormPanel pfp = new ParametersFormPanel();
        pfp.doVariables(env, scriptFile, params, null);
        params.entrySet().forEach(ent -> {
            try {
                pfp.getFormData().implement((PythonInterpreter)interp, (String)ent.getKey(), (String)ent.getValue());
            }
            catch (ParseException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        });
        interp.set("monitor", (Object)new NullProgressMonitor(){

            public boolean isCancelled() {
                return RunBatchTool.this.monitor.isCancelled();
            }
        });
        interp.set("PWD", (Object)pwd);
        return interp;
    }

    private String convertStringFormatToUriTemplate(String template) {
        String[] ss = template.split("\\%");
        StringBuilder uriTemplate = new StringBuilder(ss[0]);
        for (int i = 1; i < ss.length; ++i) {
            int firstLetter;
            String spec = ss[i];
            for (firstLetter = 0; firstLetter < spec.length() && (spec.charAt(firstLetter) == '-' || spec.charAt(firstLetter) == '.' || Character.isDigit(spec.charAt(firstLetter))); ++firstLetter) {
            }
            uriTemplate.append("$x");
            uriTemplate.append(spec.substring(firstLetter + 1));
        }
        return uriTemplate.toString();
    }
}

